/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.OptionsBase;
import com.eventstore.dbclient.ServerInfo;
import com.eventstore.dbclient.ServerVersion;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;

class WorkItemArgs {
    private final UUID id;
    private final ManagedChannel channel;
    private final InetSocketAddress endpoint;
    private final ServerInfo info;

    public WorkItemArgs(UUID id, ManagedChannel channel, InetSocketAddress endpoint, ServerInfo info) {
        this.id = id;
        this.channel = channel;
        this.endpoint = endpoint;
        this.info = info;
    }

    public UUID getId() {
        return this.id;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    public Optional<ServerVersion> getServerVersion() {
        return Optional.ofNullable(this.info).map(ServerInfo::getServerVersion);
    }

    public boolean supportFeature(int feature) {
        return this.info != null && this.info.supportFeature(feature);
    }

    public <A> HttpURLConnection getHttpConnection(OptionsBase<A> options, EventStoreDBClientSettings settings, String path) {
        try {
            HttpURLConnection conn = (HttpURLConnection)WorkItemArgs.getURL(settings.isTls(), this.endpoint, path).openConnection();
            conn.setRequestProperty("Accept", "application/json");
            String creds = options.getHttpCredentialString();
            if (creds == null && settings.getDefaultCredentials() != null) {
                creds = settings.getDefaultCredentials().basicAuthHeader();
            }
            if (creds != null) {
                conn.setRequestProperty("Authorization", creds);
            }
            return conn;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static URL getURL(boolean secure, InetSocketAddress endpoint, String path) {
        String protocol = secure ? "https" : "http";
        try {
            return new URL(protocol + "://" + endpoint.getHostName() + ":" + endpoint.getPort() + path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

