/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Checkpointer;
import com.eventstore.dbclient.ClientTelemetry;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.OptionsWithBackPressure;
import com.eventstore.dbclient.ReadResponseObserver;
import com.eventstore.dbclient.Subscription;
import com.eventstore.dbclient.SubscriptionListener;
import com.eventstore.dbclient.SubscriptionStreamConsumer;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsGrpc;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

abstract class AbstractRegularSubscription {
    protected static final StreamsOuterClass.ReadReq.Options.Builder defaultReadOptions = StreamsOuterClass.ReadReq.Options.newBuilder().setUuidOption(StreamsOuterClass.ReadReq.Options.UUIDOption.newBuilder().setStructured(Shared.Empty.getDefaultInstance()));
    protected static final StreamsOuterClass.ReadReq.Options.Builder defaultSubscribeOptions = ((StreamsOuterClass.ReadReq.Options.Builder)defaultReadOptions.clone()).setReadDirection(StreamsOuterClass.ReadReq.Options.ReadDirection.Forwards).setSubscription(StreamsOuterClass.ReadReq.Options.SubscriptionOptions.getDefaultInstance());
    protected SubscriptionListener listener;
    protected Checkpointer checkpointer = null;
    private final GrpcClient client;
    private final OptionsWithBackPressure<?> options;

    protected AbstractRegularSubscription(GrpcClient client, OptionsWithBackPressure<?> options) {
        this.client = client;
        this.options = options;
    }

    protected abstract StreamsOuterClass.ReadReq.Options.Builder createOptions();

    public CompletableFuture<Subscription> execute() {
        return this.client.run(channel -> {
            CompletableFuture<Subscription> future = new CompletableFuture<Subscription>();
            StreamsOuterClass.ReadReq readReq = StreamsOuterClass.ReadReq.newBuilder().setOptions(this.createOptions()).build();
            StreamsGrpc.StreamsStub streamsClient = GrpcUtils.configureStub(StreamsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            ReadResponseObserver observer = this.createObserver((ManagedChannel)channel, future);
            streamsClient.read(readReq, (StreamObserver<StreamsOuterClass.ReadResp>)observer);
            return future;
        });
    }

    private ReadResponseObserver createObserver(ManagedChannel channel, CompletableFuture<Subscription> future) {
        SubscriptionStreamConsumer consumer = new SubscriptionStreamConsumer(this.listener, this.checkpointer, future, (subscriptionId, event, action) -> ClientTelemetry.traceSubscribe(action, subscriptionId, channel, this.client.getSettings(), this.options.getCredentials(), event));
        return new ReadResponseObserver(this.options, consumer);
    }
}

