/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterInfo;
import com.eventstore.dbclient.ConnectionState;
import com.eventstore.dbclient.Discovery;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GossipClient;
import com.eventstore.dbclient.NoClusterNodeFoundException;
import com.eventstore.dbclient.NodeSelector;
import com.eventstore.dbclient.resolution.DeferredNodeResolution;
import com.eventstore.dbclient.resolution.DeprecatedNodeResolution;
import com.eventstore.dbclient.resolution.FixedSeedsNodeResolution;
import com.eventstore.dbclient.resolution.NodeResolution;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterDiscovery
implements Discovery {
    private static final Logger logger = LoggerFactory.getLogger(ClusterDiscovery.class);
    private final NodeSelector nodeSelector;
    private final NodeResolution resolution;

    ClusterDiscovery(EventStoreDBClientSettings settings) {
        this.nodeSelector = new NodeSelector(settings.getNodePreference());
        this.resolution = settings.isDnsDiscover() ? (settings.getFeatures().contains("dns-lookup") ? new DeprecatedNodeResolution(settings.getHosts()[0]) : new DeferredNodeResolution(settings.getHosts()[0])) : new FixedSeedsNodeResolution(settings.getHosts());
    }

    private static CompletableFuture<Optional<ClusterInfo.Member>> attemptDiscovery(NodeSelector selector, ConnectionState factory, InetSocketAddress seed) {
        factory.connect(seed);
        GossipClient client = new GossipClient(factory.getSettings(), factory.getCurrentChannel());
        return client.read().thenApply(info -> {
            if (factory.getLastConnectedEndpoint() != null) {
                info.getMembers().removeIf(member -> member.getHttpEndpoint().equals(factory.getLastConnectedEndpoint()));
            }
            return selector.determineBestFitNode((ClusterInfo)info);
        });
    }

    @Override
    public CompletableFuture<Void> run(ConnectionState state) {
        return CompletableFuture.runAsync(() -> this.discover(state));
    }

    void discover(ConnectionState state) {
        List<InetSocketAddress> candidates = this.resolution.resolve();
        if (candidates.size() > 1) {
            Collections.shuffle(candidates);
            if (state.getLastConnectedEndpoint() != null) {
                candidates.removeIf(candidate -> candidate.equals(state.getLastConnectedEndpoint()));
            }
        }
        for (InetSocketAddress seed : candidates) {
            logger.debug("Using seed node [{}] for cluster node discovery.", (Object)seed);
            try {
                Optional<ClusterInfo.Member> optionalMember = ClusterDiscovery.attemptDiscovery(this.nodeSelector, state, seed).get(state.getSettings().getGossipTimeout(), TimeUnit.MILLISECONDS);
                if (!optionalMember.isPresent()) continue;
                ClusterInfo.Member member = optionalMember.get();
                if (!member.getHttpEndpoint().equals(state.getLastConnectedEndpoint())) {
                    state.connect(member.getHttpEndpoint());
                }
                logger.debug("Selected cluster node [{}] in state [{}] for connection attempt.", (Object)member.getHttpEndpoint(), (Object)member.getState());
                return;
            }
            catch (ExecutionException | TimeoutException e) {
                logger.error("Exception during the node selection process", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new NoClusterNodeFoundException();
    }
}

