/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.ExpectedRevision;
import com.eventstore.dbclient.NodePreference;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.OperationKind;
import com.eventstore.dbclient.OptionsBase;
import com.eventstore.dbclient.StreamDeletedException;
import com.eventstore.dbclient.StreamPosition;
import com.eventstore.dbclient.ThrowingFunction;
import com.eventstore.dbclient.UserCredentials;
import com.eventstore.dbclient.WrongExpectedVersionException;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import com.google.protobuf.ByteString;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.MetadataUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

final class GrpcUtils {
    GrpcUtils() {
    }

    public static <ReqT, RespT> ClientResponseObserver<ReqT, RespT> convertSingleResponse(CompletableFuture<RespT> dest) {
        return GrpcUtils.convertSingleResponse(dest, x -> x);
    }

    public static <ReqT, RespT, TargetT, ExceptionT extends Throwable> ClientResponseObserver<ReqT, RespT> convertSingleResponse(final CompletableFuture<TargetT> dest, final ThrowingFunction<RespT, TargetT, ExceptionT> converter) {
        return new ClientResponseObserver<ReqT, RespT>(){

            public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
            }

            public void onNext(RespT value) {
                try {
                    Object converted = converter.apply(value);
                    dest.complete(converted);
                }
                catch (Throwable e) {
                    dest.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                if (t instanceof StatusRuntimeException) {
                    StatusRuntimeException e = (StatusRuntimeException)t;
                    if (e.getStatus().getCode().equals((Object)Status.FAILED_PRECONDITION.getCode())) {
                        String reason = (String)e.getTrailers().get(Metadata.Key.of((String)"exception", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                        String streamName = (String)e.getTrailers().get(Metadata.Key.of((String)"stream-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                        if (reason != null && reason.equals("stream-deleted")) {
                            dest.completeExceptionally(new StreamDeletedException(streamName));
                            return;
                        }
                        if (reason != null && reason.equals("wrong-expected-version")) {
                            String expectedStr = (String)e.getTrailers().get(Metadata.Key.of((String)"expected-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                            String actualStr = (String)e.getTrailers().get(Metadata.Key.of((String)"actual-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                            if (actualStr == null || actualStr.isEmpty()) {
                                actualStr = "-1";
                            }
                            try {
                                ExpectedRevision expected = ExpectedRevision.fromRawLong(Long.parseLong(expectedStr));
                                ExpectedRevision actual = ExpectedRevision.fromRawLong(Long.parseLong(actualStr));
                                dest.completeExceptionally(new WrongExpectedVersionException(streamName, expected, actual));
                                return;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    String leaderHost = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                    String leaderPort = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                    if (leaderHost != null && leaderPort != null) {
                        NotLeaderException reason = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                        dest.completeExceptionally(reason);
                        return;
                    }
                }
                dest.completeExceptionally(t);
            }

            public void onCompleted() {
            }
        };
    }

    public static StreamsOuterClass.ReadReq.Options.StreamOptions toStreamOptions(String streamName, StreamPosition<Long> revision) {
        StreamsOuterClass.ReadReq.Options.StreamOptions.Builder builder = StreamsOuterClass.ReadReq.Options.StreamOptions.newBuilder().setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)streamName)).build());
        if (revision.isEnd()) {
            return builder.setEnd(Shared.Empty.getDefaultInstance()).build();
        }
        if (revision.isStart()) {
            return builder.setStart(Shared.Empty.getDefaultInstance()).build();
        }
        return builder.setRevision(revision.getPositionOrThrow()).build();
    }

    public static <S extends AbstractAsyncStub<S>, O> S configureStub(S stub, EventStoreDBClientSettings settings, OptionsBase<O> options) {
        return GrpcUtils.configureStub(stub, settings, options, null);
    }

    public static <S extends AbstractAsyncStub<S>, O> S configureStub(S stub, EventStoreDBClientSettings settings, OptionsBase<O> options, Long forceDeadlineInMs) {
        Object finalStub = stub;
        ConnectionMetadata metadata = new ConnectionMetadata();
        if (options.getKind() != OperationKind.Streaming) {
            long deadlineInMs = 10000L;
            if (forceDeadlineInMs != null) {
                deadlineInMs = forceDeadlineInMs;
            } else if (options.getDeadline() != null) {
                deadlineInMs = options.getDeadline();
            } else if (settings.getDefaultDeadline() != null) {
                deadlineInMs = settings.getDefaultDeadline();
            }
            finalStub = (AbstractAsyncStub)finalStub.withDeadlineAfter(deadlineInMs, TimeUnit.MILLISECONDS);
        }
        UserCredentials credentials = null;
        if (options.hasUserCredentials()) {
            credentials = options.getCredentials();
        } else if (settings.getDefaultCredentials() != null) {
            credentials = settings.getDefaultCredentials();
        }
        if (credentials != null) {
            metadata.authenticated(credentials);
        }
        if (options.isLeaderRequired() || settings.getNodePreference() == NodePreference.LEADER) {
            metadata.requiresLeader();
        }
        metadata.headers(options.getHeaders());
        return (S)((AbstractAsyncStub)finalStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata.build())}));
    }
}

