/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Position;
import com.eventstore.dbclient.ResolvedEvent;

public final class ReadMessage {
    private Long firstStreamPosition;
    private Long lastStreamPosition;
    private Position lastAllPosition;
    private ResolvedEvent event;

    public static ReadMessage fromEvent(ResolvedEvent event) {
        ReadMessage msg = new ReadMessage();
        msg.event = event;
        return msg;
    }

    public static ReadMessage fromFirstStreamPosition(long position) {
        ReadMessage msg = new ReadMessage();
        msg.firstStreamPosition = position;
        return msg;
    }

    public static ReadMessage fromLastStreamPosition(long position) {
        ReadMessage msg = new ReadMessage();
        msg.lastStreamPosition = position;
        return msg;
    }

    public static ReadMessage fromLastAllPosition(long commit, long prepare) {
        ReadMessage msg = new ReadMessage();
        msg.lastAllPosition = new Position(commit, prepare);
        return msg;
    }

    ReadMessage() {
    }

    public boolean hasFirstStreamPosition() {
        return this.firstStreamPosition != null;
    }

    public boolean hasLastStreamPosition() {
        return this.lastStreamPosition != null;
    }

    public boolean hasLastAllPosition() {
        return this.lastAllPosition != null;
    }

    public boolean hasEvent() {
        return this.event != null;
    }

    public long getFirstStreamPosition() {
        return this.firstStreamPosition;
    }

    public long getLastStreamPosition() {
        return this.lastStreamPosition;
    }

    public Position getLastAllPosition() {
        return this.lastAllPosition;
    }

    public ResolvedEvent getEvent() {
        return this.event;
    }
}

