/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Checkpointer;
import com.eventstore.dbclient.EventFilter;
import com.eventstore.dbclient.EventTypeFilter;
import com.eventstore.dbclient.PrefixFilterExpression;
import com.eventstore.dbclient.RegularFilterExpression;
import com.eventstore.dbclient.StreamFilter;
import com.eventstore.dbclient.SubscriptionFilterBuilder;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;

public class SubscriptionFilter {
    @NotNull
    private final EventFilter filter;
    private final int checkpointIntervalUnsigned;
    private final Checkpointer checkpointer;

    public static SubscriptionFilterBuilder newBuilder() {
        return new SubscriptionFilterBuilder();
    }

    SubscriptionFilter(@NotNull EventFilter filter) {
        this.filter = filter;
        this.checkpointer = null;
        this.checkpointIntervalUnsigned = 1;
    }

    SubscriptionFilter(@NotNull EventFilter filter, int checkpointIntervalUnsigned, @NotNull Checkpointer checkpointer) {
        this.filter = filter;
        this.checkpointer = checkpointer;
        this.checkpointIntervalUnsigned = checkpointIntervalUnsigned;
    }

    Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    void addToWireStreamsReadReq(StreamsOuterClass.ReadReq.Options.Builder builder) {
        builder.setFilter(new StreamsReadReqWireBuilder(builder).build());
    }

    void addToWirePersistentCreateReq(Persistent.CreateReq.AllOptions.Builder builder) {
        builder.setFilter(new PersistentReadReqWireBuilder(builder).build());
    }

    private class StreamsReadReqWireBuilder
    extends FilterWireBase<StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.Builder> {
        StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.Builder expression;
        StreamsOuterClass.ReadReq.Options.FilterOptions.Builder filter;
        StreamsOuterClass.ReadReq.Options.Builder allOptionsBuilder;

        StreamsReadReqWireBuilder(StreamsOuterClass.ReadReq.Options.Builder builder) {
            this.expression = null;
            this.filter = null;
            this.allOptionsBuilder = null;
            this.expression = StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.newBuilder();
            this.filter = StreamsOuterClass.ReadReq.Options.FilterOptions.newBuilder();
            this.allOptionsBuilder = builder;
        }

        public StreamsOuterClass.ReadReq.Options.FilterOptions.Builder build() {
            this.internalBuild();
            this.filter.setCheckpointIntervalMultiplier(SubscriptionFilter.this.checkpointIntervalUnsigned);
            return this.filter;
        }

        @Override
        StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.Builder newExprBuilder() {
            return StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.newBuilder();
        }

        @Override
        StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.Builder setRegEx(String regEx) {
            this.expression.setRegex(regEx);
            return this.expression;
        }

        @Override
        void addPrefix(StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.Builder builder, String prefix) {
            builder.setRegex(prefix);
        }

        @Override
        void setNoFilter() {
            this.allOptionsBuilder.setNoFilter(Shared.Empty.getDefaultInstance());
        }

        @Override
        void setStreamIdentifier(StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.Builder expression) {
            this.filter.setStreamIdentifier(expression);
        }

        @Override
        void setEventType(StreamsOuterClass.ReadReq.Options.FilterOptions.Expression.Builder expression) {
            this.filter.setEventType(expression);
        }

        @Override
        void setMaxSearchWindow(Integer count) {
            this.filter.setMax(count);
        }

        @Override
        void setSearchWindowCount() {
            this.filter.setCount(Shared.Empty.getDefaultInstance());
        }
    }

    private class PersistentReadReqWireBuilder
    extends FilterWireBase<Persistent.CreateReq.AllOptions.FilterOptions.Expression.Builder> {
        Persistent.CreateReq.AllOptions.FilterOptions.Expression.Builder expression;
        Persistent.CreateReq.AllOptions.FilterOptions.Builder filter;
        Persistent.CreateReq.AllOptions.Builder allOptionsBuilder;

        PersistentReadReqWireBuilder(Persistent.CreateReq.AllOptions.Builder builder) {
            this.expression = null;
            this.filter = null;
            this.allOptionsBuilder = null;
            this.expression = Persistent.CreateReq.AllOptions.FilterOptions.Expression.newBuilder();
            this.filter = Persistent.CreateReq.AllOptions.FilterOptions.newBuilder();
            this.allOptionsBuilder = builder;
        }

        public Persistent.CreateReq.AllOptions.FilterOptions.Builder build() {
            this.internalBuild();
            return this.filter;
        }

        @Override
        Persistent.CreateReq.AllOptions.FilterOptions.Expression.Builder newExprBuilder() {
            return Persistent.CreateReq.AllOptions.FilterOptions.Expression.newBuilder();
        }

        @Override
        Persistent.CreateReq.AllOptions.FilterOptions.Expression.Builder setRegEx(String regEx) {
            this.expression.setRegex(regEx);
            return this.expression;
        }

        @Override
        void addPrefix(Persistent.CreateReq.AllOptions.FilterOptions.Expression.Builder builder, String prefix) {
            builder.setRegex(prefix);
        }

        @Override
        void setNoFilter() {
            this.allOptionsBuilder.setNoFilter(Shared.Empty.getDefaultInstance());
        }

        @Override
        void setStreamIdentifier(Persistent.CreateReq.AllOptions.FilterOptions.Expression.Builder expression) {
            this.filter.setStreamIdentifier(expression);
        }

        @Override
        void setEventType(Persistent.CreateReq.AllOptions.FilterOptions.Expression.Builder expression) {
            this.filter.setEventType(expression);
        }

        @Override
        void setMaxSearchWindow(Integer count) {
            this.filter.setMax(count);
        }

        @Override
        void setSearchWindowCount() {
            this.filter.setCount(Shared.Empty.getDefaultInstance());
        }
    }

    private abstract class FilterWireBase<TE> {
        private FilterWireBase() {
        }

        void internalBuild() {
            RegularFilterExpression regex = SubscriptionFilter.this.filter.getRegularFilterExpression();
            PrefixFilterExpression[] prefixes = SubscriptionFilter.this.filter.getPrefixFilterExpressions();
            Optional<Integer> maxSearchWindow = SubscriptionFilter.this.filter.getMaxSearchWindow();
            if (regex != null && prefixes != null && prefixes.length != 0) {
                throw new IllegalArgumentException("Regex and Prefix expressions are mutually exclusive");
            }
            TE expression = null;
            if (regex != null) {
                expression = this.setRegEx(regex.toString());
            }
            if (prefixes != null && prefixes.length > 0) {
                TE tmp = this.newExprBuilder();
                Stream.of(prefixes).map(Object::toString).filter(Objects::nonNull).distinct().forEach(s -> this.addPrefix(tmp, (String)s));
                expression = tmp;
            }
            if (expression == null) {
                this.setNoFilter();
                return;
            }
            if (SubscriptionFilter.this.filter instanceof StreamFilter) {
                this.setStreamIdentifier(expression);
            }
            if (SubscriptionFilter.this.filter instanceof EventTypeFilter) {
                this.setEventType(expression);
            }
            if (maxSearchWindow != null && maxSearchWindow.isPresent()) {
                this.setMaxSearchWindow(maxSearchWindow.get());
            } else {
                this.setSearchWindowCount();
            }
        }

        abstract TE setRegEx(String var1);

        abstract TE newExprBuilder();

        abstract void addPrefix(TE var1, String var2);

        abstract void setNoFilter();

        abstract void setStreamIdentifier(TE var1);

        abstract void setEventType(TE var1);

        abstract void setMaxSearchWindow(Integer var1);

        abstract void setSearchWindowCount();
    }
}

