/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractUpdatePersistentSubscription;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.PersistentSubscriptionSettings;
import com.eventstore.dbclient.PersistentSubscriptionToStreamSettings;
import com.eventstore.dbclient.StreamPosition;
import com.eventstore.dbclient.UpdatePersistentSubscriptionToStreamOptions;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.shared.Shared;
import com.google.protobuf.ByteString;

class UpdatePersistentSubscriptionToStream
extends AbstractUpdatePersistentSubscription {
    private final PersistentSubscriptionToStreamSettings settings;
    private final String stream;

    public UpdatePersistentSubscriptionToStream(GrpcClient connection, String stream, String group, UpdatePersistentSubscriptionToStreamOptions options) {
        super(connection, group, (PersistentSubscriptionSettings)options.getSettings(), options);
        this.stream = stream;
        this.settings = (PersistentSubscriptionToStreamSettings)options.getSettings();
    }

    @Override
    protected Persistent.UpdateReq.Settings.Builder createSettings() {
        return Persistent.UpdateReq.Settings.newBuilder();
    }

    @Override
    protected Persistent.UpdateReq.Options.Builder createOptions() {
        Persistent.UpdateReq.Options.Builder optionsBuilder = Persistent.UpdateReq.Options.newBuilder();
        Shared.StreamIdentifier.Builder streamIdentifierBuilder = Shared.StreamIdentifier.newBuilder();
        Persistent.UpdateReq.StreamOptions.Builder streamOptionsBuilder = Persistent.UpdateReq.StreamOptions.newBuilder();
        StreamPosition<Long> position = this.settings.getStartFrom();
        if (position instanceof StreamPosition.Start) {
            streamOptionsBuilder.setStart(Shared.Empty.newBuilder());
        } else if (position instanceof StreamPosition.End) {
            streamOptionsBuilder.setEnd(Shared.Empty.newBuilder());
        } else {
            streamOptionsBuilder.setRevision(position.getPositionOrThrow());
        }
        streamIdentifierBuilder.setStreamName(ByteString.copyFromUtf8((String)this.stream));
        streamOptionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        optionsBuilder.setStream(streamOptionsBuilder);
        optionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        return optionsBuilder;
    }
}

