/*
 * Decompiled with CFR 0.152.
 */
package com.excelbdd;

import com.excelbdd.TestWizard;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Behavior {
    private static final String SIMPLE = "SIMPLE";
    private static final String TESTRESULT = "TESTRESULT";
    private static final String EXPECTED = "EXPECTED";

    private Behavior() {
    }

    public static List<Map<String, String>> getExampleList(String excelPath) throws IOException {
        return Behavior.getExampleList(excelPath, "", ".*");
    }

    public static Stream<Map<String, String>> getExampleStream(String excelPath) throws IOException {
        return Behavior.getExampleList(excelPath).stream();
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, ".*");
    }

    public static Stream<Map<String, String>> getExampleStream(String excelPath, String worksheetName) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName).stream();
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, String headerMatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerMatcher, "i_m_p_o_s_i_b_l_e_matcher");
    }

    public static Stream<Map<String, String>> getExampleStream(String excelPath, String worksheetName, String headerMatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerMatcher).stream();
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, String headerMatcher, String headerUnmatcher) throws IOException {
        FileInputStream excelFile = new FileInputStream(new File(excelPath));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)excelFile);
        XSSFSheet sheetTestData = Behavior.getExampleSheet(worksheetName, excelFile, workbook);
        int headerRow = 0;
        char parameterNameColumn = '\u0000';
        String columnType = null;
        for (int iRow = 0; iRow < sheetTestData.getLastRowNum(); ++iRow) {
            XSSFRow rowCurrent = sheetTestData.getRow(iRow);
            if (rowCurrent == null) continue;
            for (int iCol = 0; iCol < rowCurrent.getLastCellNum(); ++iCol) {
                String cellValue;
                XSSFCell cellCurrent = rowCurrent.getCell(iCol);
                if (cellCurrent == null || !cellCurrent.getCellType().equals((Object)CellType.STRING) || !Behavior.isParameterNameGrid(cellValue = cellCurrent.getStringCellValue())) continue;
                parameterNameColumn = (char)(iCol + 65);
                if (Behavior.hasInputGrid(rowCurrent, iCol)) {
                    headerRow = iRow;
                    if (Behavior.hasTestResultGrid(rowCurrent, iCol)) {
                        columnType = TESTRESULT;
                        break;
                    }
                    columnType = EXPECTED;
                    break;
                }
                columnType = SIMPLE;
                headerRow = iRow + 1;
                break;
            }
            if (columnType != null) break;
        }
        if (columnType == null) {
            throw new IOException("Parameter Name grid is not found.");
        }
        return Behavior.getExampleListFromWorksheet(excelFile, sheetTestData, headerRow, parameterNameColumn, headerMatcher, headerUnmatcher, columnType);
    }

    protected static boolean hasInputGrid(XSSFRow rowCurrent, int iCol) {
        try {
            return rowCurrent.getCell(iCol + 1).getStringCellValue().equals("Input");
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected static boolean hasTestResultGrid(XSSFRow rowCurrent, int iCol) {
        try {
            return rowCurrent.getCell(iCol + 3).getStringCellValue().equals("Test Result");
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected static XSSFSheet getExampleSheet(String worksheetName, FileInputStream excelFile, XSSFWorkbook workbook) throws IOException {
        XSSFSheet sheetTestData = worksheetName.isEmpty() ? workbook.getSheetAt(0) : workbook.getSheet(worksheetName);
        if (sheetTestData == null) {
            workbook.close();
            excelFile.close();
            throw new IOException(worksheetName + " sheet does not exist.");
        }
        return sheetTestData;
    }

    private static boolean isParameterNameGrid(String cellValue) {
        return cellValue.matches("Param.*Name.*");
    }

    public static Stream<Map<String, String>> getExampleStream(String excelPath, String worksheetName, String headerMatcher, String headerUnmatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerMatcher, headerUnmatcher).stream();
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, int headerRow, char parameterNameColumn) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, ".*", "i_m_p_o_s_i_b_l_e_matcher", SIMPLE);
    }

    public static Stream<Map<String, String>> getExampleStream(String excelPath, String worksheetName, int headerRow, char parameterNameColumn) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, ".*", "i_m_p_o_s_i_b_l_e_matcher", SIMPLE).stream();
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher, "i_m_p_o_s_i_b_l_e_matcher");
    }

    public static Stream<Map<String, String>> getExampleStream(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher).stream();
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher, String headerUnmatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher, headerUnmatcher, SIMPLE);
    }

    public static Stream<Map<String, String>> getExampleStream(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher, String headerUnmatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher, headerUnmatcher).stream();
    }

    private static HashMap<Integer, Integer> getHeaderMap(String headerMatcher, String headerUnmatcher, ArrayList<Map<String, String>> listTestSet, int parameterNameColumnNum, XSSFRow rowHeader, int step) {
        XSSFCell cellHeader;
        String strRealHeaderMatcher = TestWizard.makeMatcherString(headerMatcher);
        String strRealHeaderUnmatcher = headerUnmatcher.isEmpty() || headerUnmatcher.equals("i_m_p_o_s_i_b_l_e_matcher") ? "i_m_p_o_s_i_b_l_e_matcher" : TestWizard.makeMatcherString(headerUnmatcher);
        short nMaxColumn = rowHeader.getLastCellNum();
        HashMap<Integer, Integer> mapTestSetHeader = new HashMap<Integer, Integer>();
        int nTestSet = 0;
        for (int iCol = parameterNameColumnNum + 1; iCol < nMaxColumn && (cellHeader = rowHeader.getCell(iCol)) != null; iCol += step) {
            String strHeader = cellHeader.getStringCellValue();
            if (!Behavior.isHeaderValid(strRealHeaderMatcher, strRealHeaderUnmatcher, strHeader)) continue;
            mapTestSetHeader.put(iCol, nTestSet);
            HashMap<String, String> mapTestSet = new HashMap<String, String>();
            mapTestSet.put("Header", cellHeader.getStringCellValue());
            listTestSet.add(mapTestSet);
            ++nTestSet;
        }
        return mapTestSetHeader;
    }

    private static boolean isHeaderValid(String strRealHeaderMatcher, String strRealHeaderUnmatcher, String strHeader) {
        return strHeader != null && !strHeader.isEmpty() && strHeader.matches(strRealHeaderMatcher) && !strHeader.matches(strRealHeaderUnmatcher);
    }

    private static HashMap<Integer, String> getParameterNameMap(int parameterStartRow, int parameterNameColumnNum, XSSFSheet sheetTestData) {
        HashMap<Integer, String> mapParameterName = new HashMap<Integer, String>();
        int nContinuousBlankCount = 0;
        for (int iRow = parameterStartRow; iRow <= sheetTestData.getLastRowNum() && nContinuousBlankCount <= 10; ++iRow) {
            XSSFRow rowCurrent = sheetTestData.getRow(iRow);
            if (rowCurrent == null) {
                ++nContinuousBlankCount;
                continue;
            }
            XSSFCell cellParameterName = rowCurrent.getCell(parameterNameColumnNum);
            if (cellParameterName == null) {
                ++nContinuousBlankCount;
                continue;
            }
            String strParameterName = cellParameterName.getStringCellValue();
            if (strParameterName == null || strParameterName.isEmpty()) {
                ++nContinuousBlankCount;
                continue;
            }
            if (strParameterName.equals("NA")) {
                nContinuousBlankCount = 0;
                continue;
            }
            mapParameterName.put(iRow, strParameterName);
            nContinuousBlankCount = 0;
        }
        return mapParameterName;
    }

    public static Collection<Object[]> getExampleCollection(String excelPath, String worksheetName, int headerRow, char parameterNameColumn) throws IOException {
        ArrayList<Object[]> collectionTestData = new ArrayList<Object[]>();
        List<Map<String, String>> listTestData = Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, ".*", "i_m_p_o_s_i_b_l_e_matcher", SIMPLE);
        for (Map<String, String> map : listTestData) {
            Object[] arrayObj = new Object[]{map};
            collectionTestData.add(arrayObj);
        }
        return collectionTestData;
    }

    public static List<Map<String, String>> getExampleListWithExpected(String excelPath, String worksheetName, int headerRow, char parameterNameColumn) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, ".*", "i_m_p_o_s_i_b_l_e_matcher", EXPECTED);
    }

    public static List<Map<String, String>> getExampleListWithExpected(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher, "i_m_p_o_s_i_b_l_e_matcher", EXPECTED);
    }

    public static List<Map<String, String>> getExampleListWithExpected(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher, String headerUnmatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher, headerUnmatcher, EXPECTED);
    }

    public static List<Map<String, String>> getExampleListWithTestResult(String excelPath, String worksheetName, int headerRow, char parameterNameColumn) throws IOException {
        return Behavior.getExampleListWithTestResult(excelPath, worksheetName, headerRow, parameterNameColumn, ".*");
    }

    public static List<Map<String, String>> getExampleListWithTestResult(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher, "i_m_p_o_s_i_b_l_e_matcher", TESTRESULT);
    }

    public static List<Map<String, String>> getExampleListWithTestResult(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher, String headerUnmatcher) throws IOException {
        return Behavior.getExampleList(excelPath, worksheetName, headerRow, parameterNameColumn, headerMatcher, headerUnmatcher, TESTRESULT);
    }

    public static List<Map<String, String>> getExampleList(String excelPath, String worksheetName, int headerRow, char parameterNameColumn, String headerMatcher, String headerUnmatcher, String columnType) throws IOException {
        FileInputStream excelFile = new FileInputStream(new File(excelPath));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)excelFile);
        XSSFSheet sheetTestData = Behavior.getExampleSheet(worksheetName, excelFile, workbook);
        return Behavior.getExampleListFromWorksheet(excelFile, sheetTestData, headerRow, parameterNameColumn, headerMatcher, headerUnmatcher, columnType);
    }

    private static List<Map<String, String>> getExampleListFromWorksheet(FileInputStream excelFile, XSSFSheet sheetTestData, int headerRow, char parameterNameColumn, String headerMatcher, String headerUnmatcher, String columnType) throws IOException {
        int actualHeaderRow = headerRow - 1;
        int actualParameterStartRow = headerRow;
        int columnStep = 1;
        if (TESTRESULT.equals(columnType)) {
            actualParameterStartRow = headerRow + 1;
            columnStep = 3;
        } else if (EXPECTED.equals(columnType)) {
            actualParameterStartRow = headerRow + 1;
            columnStep = 2;
        }
        ArrayList<Map<String, String>> listTestSet = new ArrayList<Map<String, String>>();
        int parameterNameColumnNum = parameterNameColumn - 65;
        XSSFRow rowHeader = sheetTestData.getRow(actualHeaderRow);
        HashMap<Integer, Integer> mapTestSetHeader = Behavior.getHeaderMap(headerMatcher, headerUnmatcher, listTestSet, parameterNameColumnNum, rowHeader, columnStep);
        HashMap<Integer, String> mapParameterName = Behavior.getParameterNameMap(actualParameterStartRow, parameterNameColumnNum, sheetTestData);
        for (Map.Entry<Integer, String> aParameterName : mapParameterName.entrySet()) {
            int iRow = aParameterName.getKey();
            String strParameterName = aParameterName.getValue();
            XSSFRow rowCurrent = sheetTestData.getRow(iRow);
            for (Map.Entry<Integer, Integer> entryHeader : mapTestSetHeader.entrySet()) {
                int iCol = entryHeader.getKey();
                Map<String, String> mapTestSet = listTestSet.get(entryHeader.getValue());
                Behavior.putParameter(strParameterName, rowCurrent, mapTestSet, iCol);
                if (columnStep <= 1) continue;
                Behavior.putParameter(strParameterName + "Expected", rowCurrent, mapTestSet, iCol + 1);
                if (columnStep != 3) continue;
                Behavior.putParameter(strParameterName + "TestResult", rowCurrent, mapTestSet, iCol + 2);
            }
        }
        sheetTestData.getWorkbook().close();
        excelFile.close();
        return listTestSet;
    }

    private static void putParameter(String strParameterName, XSSFRow rowCurrent, Map<String, String> mapTestSet, int iCol) {
        XSSFCell cellCurrent = rowCurrent.getCell(iCol);
        if (cellCurrent == null) {
            mapTestSet.put(strParameterName, "");
        } else if (cellCurrent.getCellType().equals((Object)CellType.STRING)) {
            mapTestSet.put(strParameterName, cellCurrent.getStringCellValue());
        } else if (cellCurrent.getCellType().equals((Object)CellType.BLANK)) {
            mapTestSet.put(strParameterName, "");
        } else if (cellCurrent.getCellType().equals((Object)CellType.NUMERIC)) {
            mapTestSet.put(strParameterName, String.valueOf(cellCurrent.getNumericCellValue()));
        } else if (cellCurrent.getCellType().equals((Object)CellType.BOOLEAN)) {
            mapTestSet.put(strParameterName, String.valueOf(cellCurrent.getBooleanCellValue()));
        } else {
            mapTestSet.put(strParameterName, cellCurrent.getRawValue());
        }
    }
}

