/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.example;

import ch.qos.logback.classic.Level;
import com.featureprobe.sdk.server.FPConfig;
import com.featureprobe.sdk.server.FPDetail;
import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.FeatureProbe;
import com.featureprobe.sdk.server.Loggers;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureProbeDemo {
    private static final Logger logger = Loggers.MAIN;
    private static final String FEATURE_PROBE_SERVER_URL = "http://localhost:4009/server";
    public static final String FEATURE_PROBE_SERVER_SDK_KEY = "server-8ed48815ef044428826787e9a238b9c6a479f98c";

    public static void main(String[] args) throws IOException, InterruptedException {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.WARN);
        FPConfig config = FPConfig.builder().remoteUri(FEATURE_PROBE_SERVER_URL).startWait(5L, TimeUnit.SECONDS).build();
        FeatureProbe fpClient = new FeatureProbe(FEATURE_PROBE_SERVER_SDK_KEY, config);
        if (!fpClient.initialized()) {
            logger.error("SDK failed to initialize!");
        }
        FPUser user = new FPUser().with("userId", "00001");
        String YOUR_TOGGLE_KEY = "campaign_allow_list";
        Boolean isOpen = fpClient.boolValue("campaign_allow_list", user, false);
        System.out.println("feature for this user is :" + isOpen);
        FPDetail<Boolean> isOpenDetail = fpClient.boolDetail("campaign_allow_list", user, false);
        System.out.println("detail:" + isOpenDetail.getReason());
        System.out.println("rule index:" + isOpenDetail.getRuleIndex());
        String YOUR_CUSTOM_EVENT_NAME = "new_feature_conversion";
        for (int i = 0; i < 1000; ++i) {
            FPUser eventUser = new FPUser().stableRollout(String.valueOf(System.nanoTime()));
            boolean newFeature = fpClient.boolValue("campaign_allow_list", eventUser, false);
            Random random = new Random();
            int randomRang = random.nextInt(100);
            if (newFeature) {
                if (randomRang <= 55) {
                    System.out.println("New feature conversion.");
                    fpClient.track("new_feature_conversion", eventUser);
                }
            } else if (randomRang > 55) {
                System.out.println("Old feature conversion.");
                fpClient.track("new_feature_conversion", eventUser);
            }
            Thread.sleep(200L);
        }
        fpClient.close();
    }
}

