/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.featureprobe.sdk.server.DataRepository;
import com.featureprobe.sdk.server.model.Repository;
import com.featureprobe.sdk.server.model.Segment;
import com.featureprobe.sdk.server.model.Toggle;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

final class MemoryDataRepository
implements DataRepository {
    private volatile Repository data;
    private volatile boolean initialized = false;
    private volatile Long updatedTimestamp = 0L;

    MemoryDataRepository() {
    }

    @Override
    public void refresh(Repository repository) {
        if (Objects.nonNull(repository) && Objects.nonNull(repository.getToggles()) && Objects.nonNull(repository.getSegments())) {
            ImmutableMap toggles = ImmutableMap.copyOf(repository.getToggles());
            ImmutableMap segments = ImmutableMap.copyOf(repository.getSegments());
            this.data = new Repository((Map<String, Toggle>)toggles, (Map<String, Segment>)segments);
            this.initialized = true;
            this.updatedTimestamp = System.currentTimeMillis();
        }
    }

    @Override
    public Toggle getToggle(String key) {
        if (this.initialized) {
            return this.data.getToggles().get(key);
        }
        return null;
    }

    @Override
    public Map<String, Toggle> getAllToggle() {
        if (this.initialized) {
            return this.data.getToggles();
        }
        return ImmutableMap.of();
    }

    @Override
    public Segment getSegment(String key) {
        if (this.initialized) {
            return this.data.getSegments().get(key);
        }
        return null;
    }

    @Override
    public Map<String, Segment> getAllSegment() {
        if (this.initialized) {
            return this.data.getSegments();
        }
        return ImmutableMap.of();
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public void close() {
        this.data = null;
    }
}

