/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server;

import com.featureprobe.sdk.server.DataRepository;
import com.featureprobe.sdk.server.FPContext;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.PollingSynchronizer;
import com.featureprobe.sdk.server.Synchronizer;
import com.google.common.annotations.VisibleForTesting;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class StreamingSynchronizer
implements Synchronizer {
    private static final Logger logger = Loggers.SYNCHRONIZER;
    private PollingSynchronizer pollingSynchronizer;
    @VisibleForTesting
    Socket socket;

    StreamingSynchronizer(FPContext context, DataRepository dataRepository) {
        this.pollingSynchronizer = new PollingSynchronizer(context, dataRepository);
        this.socket = this.connectSocket(context);
    }

    @Override
    public Future<Void> sync() {
        return this.pollingSynchronizer.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        StreamingSynchronizer streamingSynchronizer = this;
        synchronized (streamingSynchronizer) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
    }

    private Socket connectSocket(FPContext context) {
        IO.Options sioOptions = IO.Options.builder().setTransports(new String[]{"websocket"}).setPath(context.getRealtimeUri().getPath()).build();
        Socket sio = IO.socket((URI)context.getRealtimeUri(), (IO.Options)sioOptions);
        sio.on("connect", objects -> {
            logger.info("connect socket-io success");
            HashMap<String, String> credentials = new HashMap<String, String>(1);
            credentials.put("key", context.getServerSdkKey());
            sio.emit("register", new Object[]{credentials});
        });
        sio.on("update", objects -> {
            logger.info("socket-io recv update event");
            this.pollingSynchronizer.poll();
        });
        sio.on("disconnect", objects -> logger.info("socket-io disconnected"));
        sio.on("connect_error", objects -> logger.error("socket-io error: {}", objects));
        return sio.connect();
    }
}

