/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server.model;

import com.featureprobe.sdk.server.EvaluationResult;
import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.HitResult;
import com.featureprobe.sdk.server.exceptions.PrerequisitesDeepOverflowException;
import com.featureprobe.sdk.server.model.Prerequisite;
import com.featureprobe.sdk.server.model.Rule;
import com.featureprobe.sdk.server.model.Segment;
import com.featureprobe.sdk.server.model.Serve;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class Toggle {
    private String key;
    private Boolean enabled;
    private Boolean trackAccessEvents;
    private Long lastModified;
    private Long version;
    private Serve disabledServe;
    private Serve defaultServe;
    private List<Rule> rules;
    private List<Object> variations;
    private List<Prerequisite> prerequisites;
    private Boolean forClient;

    public EvaluationResult eval(FPUser user, Map<String, Toggle> toggles, Map<String, Segment> segments, Object defaultValue, int deep) {
        String warning = "";
        if (!this.enabled.booleanValue()) {
            return this.createDisabledResult(user, this.key, defaultValue);
        }
        if (deep <= 0) {
            throw new PrerequisitesDeepOverflowException("prerequisite deep overflow");
        }
        if (!this.prerequisite(user, toggles, segments, deep)) {
            return this.createDefaultResult(user, this.key, defaultValue, warning);
        }
        if (this.rules != null && this.rules.size() > 0) {
            for (int i = 0; i < this.rules.size(); ++i) {
                Rule rule = this.rules.get(i);
                HitResult hitResult = rule.hit(user, segments, this.key);
                if (hitResult.isHit()) {
                    return this.hitValue(hitResult, defaultValue, Optional.of(i));
                }
                warning = hitResult.getReason().orElse("");
            }
        }
        return this.createDefaultResult(user, this.key, defaultValue, warning);
    }

    private EvaluationResult createDisabledResult(FPUser user, String toggleKey, Object defaultValue) {
        EvaluationResult disabledResult = this.hitValue(this.disabledServe.evalIndex(user, this.key), defaultValue, Optional.empty());
        disabledResult.setReason("Toggle disabled");
        return disabledResult;
    }

    private EvaluationResult createDefaultResult(FPUser user, String toggleKey, Object defaultValue, String warning) {
        EvaluationResult defaultResult = this.hitValue(this.defaultServe.evalIndex(user, toggleKey), defaultValue, Optional.empty());
        defaultResult.setReason("Default rule hit. " + warning);
        return defaultResult;
    }

    private boolean prerequisite(FPUser user, Map<String, Toggle> toggles, Map<String, Segment> segments, int deep) {
        if (Objects.isNull(this.prerequisites) || this.prerequisites.isEmpty()) {
            return true;
        }
        for (Prerequisite prerequisite : this.prerequisites) {
            Toggle toggle = toggles.get(prerequisite.getKey());
            if (Objects.isNull(toggle)) {
                return false;
            }
            EvaluationResult eval = toggle.eval(user, toggles, segments, null, deep - 1);
            if (Objects.isNull(eval.getValue())) {
                return false;
            }
            if (eval.getValue().equals(prerequisite.getValue())) continue;
            return false;
        }
        return true;
    }

    private EvaluationResult hitValue(HitResult hitResult, Object defaultValue, Optional<Integer> ruleIndex) {
        EvaluationResult res = new EvaluationResult(defaultValue, ruleIndex, hitResult.getIndex(), this.version, hitResult.getReason().orElse(""));
        if (hitResult.getIndex().isPresent()) {
            Object variation = this.variations.get(hitResult.getIndex().get());
            if (defaultValue instanceof Double && variation instanceof Integer) {
                res.setValue((Integer)variation);
            } else {
                res.setValue(variation);
            }
            ruleIndex.ifPresent(idx -> res.setReason("Rule " + idx + " hit"));
        }
        return res;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Serve getDisabledServe() {
        return this.disabledServe;
    }

    public void setDisabledServe(Serve disabledServe) {
        this.disabledServe = disabledServe;
    }

    public Serve getDefaultServe() {
        return this.defaultServe;
    }

    public void setDefaultServe(Serve defaultServe) {
        this.defaultServe = defaultServe;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public List<Object> getVariations() {
        return this.variations;
    }

    public void setVariations(List<Object> variations) {
        this.variations = variations;
    }

    public Boolean getForClient() {
        return this.forClient;
    }

    public void setForClient(Boolean forClient) {
        this.forClient = forClient;
    }

    public void setTrackAccessEvents(Boolean trackAccessEvents) {
        this.trackAccessEvents = trackAccessEvents;
    }

    public Boolean getTrackAccessEvents() {
        return this.trackAccessEvents;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<Prerequisite> prerequisites) {
        this.prerequisites = prerequisites;
    }
}

