/*
 * Decompiled with CFR 0.152.
 */
package com.featureprobe.sdk.server.model;

import com.featureprobe.sdk.server.DatetimeMatcher;
import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.Loggers;
import com.featureprobe.sdk.server.NumberMatcher;
import com.featureprobe.sdk.server.SegmentMatcher;
import com.featureprobe.sdk.server.SemverMatcher;
import com.featureprobe.sdk.server.StringMatcher;
import com.featureprobe.sdk.server.model.ConditionType;
import com.featureprobe.sdk.server.model.PredicateType;
import com.featureprobe.sdk.server.model.Segment;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;

public final class Condition {
    private static final Logger logger = Loggers.EVALUATOR;
    private ConditionType type;
    private String subject;
    private PredicateType predicate;
    private List<String> objects;
    private static final long MILLISECONDS_IN_ONE_SEC = 1000L;
    private static final Map<PredicateType, StringMatcher> stringMatchers = new EnumMap<PredicateType, StringMatcher>(PredicateType.class);
    private static final Map<PredicateType, SegmentMatcher> segmentMatchers = new EnumMap<PredicateType, SegmentMatcher>(PredicateType.class);
    private static final Map<PredicateType, DatetimeMatcher> datetimeMatchers = new EnumMap<PredicateType, DatetimeMatcher>(PredicateType.class);
    private static final Map<PredicateType, NumberMatcher> numberMatchers = new EnumMap<PredicateType, NumberMatcher>(PredicateType.class);
    private static final Map<PredicateType, SemverMatcher> semverMatchers = new EnumMap<PredicateType, SemverMatcher>(PredicateType.class);

    public boolean matchObjects(FPUser user, Map<String, Segment> segments) {
        switch (this.type) {
            case STRING: {
                return this.matchStringCondition(user);
            }
            case SEGMENT: {
                return this.matchSegmentCondition(user, segments);
            }
            case DATETIME: {
                return this.matchDatetimeCondition(user);
            }
            case NUMBER: {
                return this.matchNumberCondition(user);
            }
            case SEMVER: {
                return this.matchSemverCondition(user);
            }
        }
        return false;
    }

    private boolean matchStringCondition(FPUser user) {
        if (!user.containAttr(this.subject)) {
            return false;
        }
        String subjectValue = user.getAttr(this.subject);
        StringMatcher stringMatcher = stringMatchers.get((Object)this.predicate);
        if (Objects.isNull(stringMatcher)) {
            return false;
        }
        try {
            return stringMatcher.match(subjectValue, this.objects);
        }
        catch (PatternSyntaxException e) {
            logger.error("Invalid regex pattern", e);
            return false;
        }
    }

    private boolean matchSegmentCondition(FPUser user, Map<String, Segment> segments) {
        SegmentMatcher segmentMatcher = segmentMatchers.get((Object)this.predicate);
        if (Objects.isNull(segmentMatcher)) {
            return false;
        }
        return segmentMatcher.match(user, segments, this.objects);
    }

    private boolean matchDatetimeCondition(FPUser user) {
        long cv;
        DatetimeMatcher datetimeMatcher = datetimeMatchers.get((Object)this.predicate);
        if (Objects.isNull(datetimeMatcher)) {
            return false;
        }
        String customValue = user.getAttr(this.subject);
        try {
            cv = StringUtils.isBlank(customValue) ? System.currentTimeMillis() / 1000L : Long.parseLong(customValue);
        }
        catch (NumberFormatException e) {
            logger.error("User attribute type mismatch. attribute value: {}, target type long", (Object)customValue);
            return false;
        }
        try {
            return datetimeMatcher.match(cv, this.objects);
        }
        catch (NumberFormatException e) {
            logger.error("Met a string that cannot be parsed to long in Condition.objects: {}", (Object)e.getMessage());
            return false;
        }
    }

    private boolean matchNumberCondition(FPUser user) {
        double cv;
        NumberMatcher numberMatcher = numberMatchers.get((Object)this.predicate);
        if (Objects.isNull(numberMatcher)) {
            return false;
        }
        String customValue = user.getAttr(this.subject);
        if (StringUtils.isBlank(customValue)) {
            return false;
        }
        try {
            cv = Double.parseDouble(customValue);
        }
        catch (NumberFormatException e) {
            logger.error("User attribute type mismatch. attribute value : {}, target type double", (Object)customValue);
            return false;
        }
        try {
            return numberMatcher.match(cv, this.objects);
        }
        catch (NumberFormatException e) {
            logger.error("Met a string that cannot be parsed to double in Condition.objects: {}", (Object)e.getMessage());
            return false;
        }
    }

    private boolean matchSemverCondition(FPUser user) {
        SemverMatcher semverMatcher = semverMatchers.get((Object)this.predicate);
        if (Objects.isNull(semverMatcher)) {
            return false;
        }
        String customValue = user.getAttr(this.subject);
        if (StringUtils.isBlank(customValue)) {
            return false;
        }
        ComparableVersion cv = new ComparableVersion(customValue);
        return semverMatcher.match(cv, this.objects);
    }

    public ConditionType getType() {
        return this.type;
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPredicate() {
        return Objects.isNull((Object)this.predicate) ? null : this.predicate.toValue();
    }

    public void setPredicate(PredicateType predicate) {
        this.predicate = predicate;
    }

    public List<String> getObjects() {
        return this.objects;
    }

    public void setObjects(List<String> objects) {
        this.objects = objects;
    }

    static {
        stringMatchers.put(PredicateType.IS_ONE_OF, (target, objects) -> objects.contains(target));
        stringMatchers.put(PredicateType.ENDS_WITH, (target, objects) -> {
            if (!Objects.nonNull(target)) return false;
            if (!objects.stream().anyMatch(target::endsWith)) return false;
            return true;
        });
        stringMatchers.put(PredicateType.STARTS_WITH, (target, objects) -> {
            if (!Objects.nonNull(target)) return false;
            if (!objects.stream().anyMatch(target::startsWith)) return false;
            return true;
        });
        stringMatchers.put(PredicateType.CONTAINS, (target, objects) -> {
            if (!Objects.nonNull(target)) return false;
            if (!objects.stream().anyMatch(target::contains)) return false;
            return true;
        });
        stringMatchers.put(PredicateType.MATCHES_REGEX, (target, objects) -> objects.stream().anyMatch(s2 -> Objects.nonNull(target) && Pattern.compile(s2).matcher(target).find()));
        stringMatchers.put(PredicateType.IS_NOT_ANY_OF, (target, objects) -> !objects.contains(target));
        stringMatchers.put(PredicateType.DOES_NOT_END_WITH, (target, objects) -> {
            if (!Objects.nonNull(target)) return false;
            if (!objects.stream().noneMatch(target::endsWith)) return false;
            return true;
        });
        stringMatchers.put(PredicateType.DOES_NOT_START_WITH, (target, objects) -> {
            if (!Objects.nonNull(target)) return false;
            if (!objects.stream().noneMatch(target::startsWith)) return false;
            return true;
        });
        stringMatchers.put(PredicateType.DOES_NOT_CONTAIN, (target, objects) -> {
            if (!Objects.nonNull(target)) return false;
            if (!objects.stream().noneMatch(target::contains)) return false;
            return true;
        });
        stringMatchers.put(PredicateType.DOES_NOT_MATCH_REGEX, (target, objects) -> Objects.nonNull(target) && objects.stream().noneMatch(s2 -> Pattern.compile(s2).matcher(target).find()));
        segmentMatchers.put(PredicateType.IS_IN, (user, segments, objects) -> objects.stream().anyMatch(s2 -> ((Segment)segments.get(s2)).contains(user, segments)));
        segmentMatchers.put(PredicateType.IS_NOT_IN, (user, segments, objects) -> objects.stream().noneMatch(s2 -> ((Segment)segments.get(s2)).contains(user, segments)));
        datetimeMatchers.put(PredicateType.AFTER, (target, objects) -> objects.stream().map(Long::parseLong).anyMatch(o -> target >= o));
        datetimeMatchers.put(PredicateType.BEFORE, (target, objects) -> objects.stream().map(Long::parseLong).anyMatch(o -> target < o));
        numberMatchers.put(PredicateType.EQUAL_TO, (target, objects) -> objects.stream().map(Double::parseDouble).anyMatch(o -> target == o));
        numberMatchers.put(PredicateType.NOT_EQUAL_TO, (target, objects) -> objects.stream().map(Double::parseDouble).noneMatch(o -> target == o));
        numberMatchers.put(PredicateType.GREATER_THAN, (target, objects) -> objects.stream().map(Double::parseDouble).anyMatch(o -> target > o));
        numberMatchers.put(PredicateType.GREATER_OR_EQUAL, (target, objects) -> objects.stream().map(Double::parseDouble).anyMatch(o -> target >= o));
        numberMatchers.put(PredicateType.LESS_THAN, (target, objects) -> objects.stream().map(Double::parseDouble).anyMatch(o -> target < o));
        numberMatchers.put(PredicateType.LESS_OR_EQUAL, (target, objects) -> objects.stream().map(Double::parseDouble).anyMatch(o -> target <= o));
        semverMatchers.put(PredicateType.EQUAL_TO, (target, objects) -> objects.stream().filter(Objects::nonNull).map(ComparableVersion::new).anyMatch(t -> target.compareTo((ComparableVersion)t) == 0));
        semverMatchers.put(PredicateType.NOT_EQUAL_TO, (target, objects) -> objects.stream().filter(Objects::nonNull).map(ComparableVersion::new).noneMatch(t -> target.compareTo((ComparableVersion)t) == 0));
        semverMatchers.put(PredicateType.GREATER_THAN, (target, objects) -> objects.stream().filter(Objects::nonNull).map(ComparableVersion::new).anyMatch(t -> target.compareTo((ComparableVersion)t) > 0));
        semverMatchers.put(PredicateType.GREATER_OR_EQUAL, (target, objects) -> objects.stream().filter(Objects::nonNull).map(ComparableVersion::new).anyMatch(t -> target.compareTo((ComparableVersion)t) >= 0));
        semverMatchers.put(PredicateType.LESS_THAN, (target, objects) -> objects.stream().filter(Objects::nonNull).map(ComparableVersion::new).anyMatch(t -> target.compareTo((ComparableVersion)t) < 0));
        semverMatchers.put(PredicateType.LESS_OR_EQUAL, (target, objects) -> objects.stream().filter(Objects::nonNull).map(ComparableVersion::new).anyMatch(t -> target.compareTo((ComparableVersion)t) <= 0));
    }
}

