/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.python;

import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.model.ClassificationMLModel;
import com.feedzai.openml.provider.descriptor.fieldtype.ParamValidationError;
import com.feedzai.openml.provider.exception.ModelLoadingException;
import com.feedzai.openml.provider.model.MachineLearningModelLoader;
import com.feedzai.openml.python.ClassificationPythonModel;
import com.feedzai.openml.python.jep.instance.JepInstance;
import com.feedzai.openml.util.load.LoadSchemaUtils;
import com.feedzai.openml.util.validate.ClassificationValidationUtils;
import com.feedzai.openml.util.validate.ValidationUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassificationPythonModelLoaderImpl
implements MachineLearningModelLoader<ClassificationPythonModel> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClassificationPythonModelLoaderImpl.class);

    public ClassificationPythonModel loadModel(Path modelPath, DatasetSchema schema) throws ModelLoadingException {
        logger.info("Trying to load a model in path [{}]...", (Object)modelPath);
        ClassificationValidationUtils.validateParamsModelToLoad((MachineLearningModelLoader)this, (Path)modelPath, (DatasetSchema)schema, ImmutableMap.of());
        JepInstance jepInstance = new JepInstance();
        String id = this.generateNamesafeId();
        try {
            jepInstance.start();
            this.modelLoadLogic(jepInstance, id, modelPath);
            jepInstance.submitEvaluation(jep -> {
                jep.eval("import numpy");
                return null;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Could not load the model [{}].", (Object)modelPath, (Object)e);
            throw new ModelLoadingException("Error while loading the model.", (Throwable)e);
        }
        Optional validationError = ValidationUtils.validateCategoricalSchema((DatasetSchema)schema);
        Preconditions.checkArgument(!validationError.isPresent(), "Target variable must be categorical: %s", validationError);
        ClassificationPythonModel model = this.getModelImpl(schema, jepInstance, id);
        this.validateLoadedModel(schema, jepInstance, id, model);
        logger.info("Model loaded successfully.");
        return model;
    }

    protected ClassificationPythonModel getModelImpl(DatasetSchema schema, JepInstance jepInstance, String id) {
        return new ClassificationPythonModel(jepInstance, schema, id);
    }

    protected abstract void modelLoadLogic(JepInstance var1, String var2, Path var3) throws InterruptedException, ExecutionException, ModelLoadingException;

    private String generateNamesafeId() {
        byte[] base64encodedUUID = Base64.getUrlEncoder().encode(UUID.randomUUID().toString().getBytes());
        return String.format("model_%s", new String(base64encodedUUID));
    }

    private void validateLoadedModel(DatasetSchema schema, JepInstance jepInstance, String id, ClassificationPythonModel model) throws ModelLoadingException {
        model.validate(jepInstance, id);
        ClassificationValidationUtils.validateClassificationModel((DatasetSchema)schema, (ClassificationMLModel)model);
    }

    public List<ParamValidationError> validateForLoad(Path modelPath, DatasetSchema schema, Map<String, String> params) {
        return ValidationUtils.baseLoadValidations((DatasetSchema)schema, params);
    }

    public DatasetSchema loadSchema(Path modelPath) throws ModelLoadingException {
        return LoadSchemaUtils.datasetSchemaFromJson((Path)modelPath);
    }
}

