/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.python.jep.instance;

import com.feedzai.openml.python.jep.instance.AbstractJepEvaluation;
import com.feedzai.openml.python.jep.instance.JepFunction;
import com.feedzai.openml.python.modules.SharedModulesParser;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import jep.Jep;
import jep.JepConfig;
import jep.JepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JepInstance
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(JepInstance.class);
    private static final int THREAD_JOIN_TIMEOUT_SECONDS = 10;
    private volatile boolean running = false;
    private final Thread thread = new Thread(this);
    private final BlockingQueue<AbstractJepEvaluation> evaluationQueue = new LinkedBlockingQueue<AbstractJepEvaluation>();

    public void start() {
        this.thread.start();
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.thread.interrupt();
        Uninterruptibles.joinUninterruptibly(this.thread, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ImmutableCollection sharedModules = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("tensorflow")).add("numpy")).addAll(new SharedModulesParser().getSharedModules())).build();
        logger.debug("Python modules to be shared: {}", (Object)String.join((CharSequence)",", ((Object)sharedModules).toString()));
        JepConfig jepConfig = new JepConfig().addSharedModules(sharedModules.toArray(new String[0])).setInteractive(false);
        try (Jep jep = new Jep(jepConfig);){
            while (this.running) {
                this.evaluationQueue.take().evaluate(jep);
            }
        }
        catch (JepException e) {
            logger.error("A problem occurred that caused Jep to crash!", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.running = false;
        }
    }

    public <T> AbstractJepEvaluation<T> submitEvaluation(final JepFunction<T> evaluationFunction) {
        if (!this.running) {
            throw new RuntimeException("Jep instance is not running.");
        }
        AbstractJepEvaluation evaluation = new AbstractJepEvaluation<T>(){

            @Override
            public T apply(Jep jep) throws JepException {
                return evaluationFunction.apply(jep);
            }
        };
        this.evaluationQueue.add(evaluation);
        return evaluation;
    }
}

