/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.python.modules;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SharedModulesParser {
    private static final Logger logger = LoggerFactory.getLogger(SharedModulesParser.class);
    private static final String DEFAULT_XML_FILE = "python-packages.xml";
    private final String xmlFile;

    public SharedModulesParser(String xmlFileName) {
        this.xmlFile = xmlFileName;
    }

    public SharedModulesParser() {
        this(DEFAULT_XML_FILE);
    }

    private InputStream getXMLInputStream() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream(this.xmlFile);
    }

    private Set<String> parseXMLFile() throws Exception {
        ImmutableSet.Builder sharedModulesBuilder = ImmutableSet.builder();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        try (InputStream xmlFile = this.getXMLInputStream();){
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("package");
            for (int i = 0; i < nList.getLength(); ++i) {
                sharedModulesBuilder.add(nList.item(i).getFirstChild().getNodeValue());
            }
        }
        return sharedModulesBuilder.build();
    }

    public Set<String> getSharedModules() {
        ImmutableSet<String> sharedModules = ImmutableSet.of();
        try {
            sharedModules = this.parseXMLFile();
        }
        catch (Exception e) {
            logger.warn("Problem while getting the XML file with the Python modules to be shared.", (Throwable)e);
        }
        return sharedModules;
    }
}

