/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.FlagsmithLoggerLevel;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;

public class FlagsmithLogger {
    private Logger logger;
    private FlagsmithLoggerLevel level = FlagsmithLoggerLevel.ERROR;

    public void setLogger(Logger logger, FlagsmithLoggerLevel level) {
        this.logger = logger;
        this.level = level;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void httpError(Request request, Response response) {
        if (this.logger != null) {
            String body = null;
            try {
                body = response.body().string();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logger.error("Flagsmith: error when getting flags. Request: {}, Response: {} body[{}]", new Object[]{request.url(), response, body});
        }
    }

    public void httpError(Request request, IOException io) {
        if (this.logger != null) {
            this.logger.error("Flagsmith: error when getting flags. Request: {}", (Object)request.url(), (Object)io);
        }
    }

    public void info(String var1, Object ... var2) {
        if (this.logger != null && FlagsmithLoggerLevel.INFO.getValue() >= this.level.getValue()) {
            this.logger.info("Flagsmith: " + var1, var2);
        }
    }
}

