/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.config;

import com.flagsmith.interfaces.FlagsmithCache;
import com.flagsmith.models.Flags;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class FlagsmithCacheConfig {
    private static final int DEFAULT_MAX_SIZE = 10;
    private static final int DEFAULT_EXPIRE_AFTER_WRITE = 5;
    private static final TimeUnit DEFAULT_EXPIRE_AFTER_WRITE_TIMEUNIT = TimeUnit.MINUTES;
    final FlagsmithCacheImpl cache;

    private FlagsmithCacheConfig(Builder builder) {
        Caffeine caffeineBuilder = Caffeine.newBuilder();
        if (builder.expireAfterWrite > -1) {
            caffeineBuilder = caffeineBuilder.expireAfterWrite((long)builder.expireAfterWrite, builder.expireAfterWriteTimeUnit);
        }
        if (builder.expireAfterAccess > -1) {
            caffeineBuilder = caffeineBuilder.expireAfterAccess((long)builder.expireAfterAccess, builder.expireAfterAccessTimeUnit);
        }
        if (builder.maxSize > -1) {
            caffeineBuilder = caffeineBuilder.maximumSize((long)builder.maxSize);
        }
        if (builder.recordStats) {
            caffeineBuilder = caffeineBuilder.recordStats();
        }
        this.cache = new FlagsmithCacheImpl((Cache<String, Flags>)caffeineBuilder.build(), builder.envFlagsCacheKey);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Generated
    public FlagsmithCacheImpl getCache() {
        return this.cache;
    }

    static /* synthetic */ TimeUnit access$800() {
        return DEFAULT_EXPIRE_AFTER_WRITE_TIMEUNIT;
    }

    public static class Builder {
        private TimeUnit expireAfterWriteTimeUnit = FlagsmithCacheConfig.access$800();
        private int expireAfterWrite = 5;
        private TimeUnit expireAfterAccessTimeUnit;
        private int expireAfterAccess = -1;
        private int maxSize = 10;
        private boolean recordStats = false;
        private String envFlagsCacheKey = null;

        private Builder() {
        }

        public Builder expireAfterWrite(int duration, TimeUnit timeUnit) {
            this.expireAfterWrite = duration;
            this.expireAfterWriteTimeUnit = timeUnit;
            return this;
        }

        public Builder expireAfterAccess(int duration, TimeUnit timeUnit) {
            this.expireAfterAccess = duration;
            this.expireAfterAccessTimeUnit = timeUnit;
            return this;
        }

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder recordStats() {
            this.recordStats = true;
            return this;
        }

        public Builder enableEnvLevelCaching(String envFlagsCacheKey) {
            if (envFlagsCacheKey == null || StringUtils.isBlank((CharSequence)envFlagsCacheKey)) {
                throw new IllegalArgumentException("Missing environment level cache key");
            }
            this.envFlagsCacheKey = envFlagsCacheKey;
            return this;
        }

        public FlagsmithCacheConfig build() {
            return new FlagsmithCacheConfig(this);
        }
    }

    public class FlagsmithCacheImpl
    implements FlagsmithCache {
        private final Cache<String, Flags> cache;
        private final String envFlagsCacheKey;

        public FlagsmithCacheImpl(Cache<String, Flags> cache, String envFlagsCacheKey) {
            this.cache = cache;
            this.envFlagsCacheKey = envFlagsCacheKey;
        }

        public FlagsmithCacheImpl(Cache<String, Flags> cache) {
            this.cache = cache;
            this.envFlagsCacheKey = null;
        }

        @Override
        public void cleanUp() {
            this.cache.cleanUp();
        }

        @Override
        public void invalidateAll() {
            this.cache.invalidateAll();
        }

        @Override
        public void invalidate(String userId) {
            this.cache.invalidate((Object)userId);
        }

        @Override
        public long estimatedSize() {
            return this.cache.estimatedSize();
        }

        @Override
        public CacheStats stats() {
            return this.cache.stats();
        }

        @Override
        public Flags getIfPresent(String key) {
            return (Flags)this.cache.getIfPresent((Object)key);
        }

        @Override
        public String getEnvFlagsCacheKey() {
            return this.envFlagsCacheKey;
        }

        @Override
        public String getIdentityFlagsCacheKey(String identifier, boolean isTransient) {
            return "identity" + identifier + (isTransient ? "transient" : "");
        }

        @Override
        public Cache<String, Flags> getCache() {
            return this.cache;
        }
    }
}

