/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.flagsmith.flagengine.EvaluationContext;
import com.flagsmith.flagengine.EvaluationResult;
import com.flagsmith.flagengine.FeatureContext;
import com.flagsmith.flagengine.FeatureValue;
import com.flagsmith.flagengine.Features;
import com.flagsmith.flagengine.FlagResult;
import com.flagsmith.flagengine.Flags;
import com.flagsmith.flagengine.IdentityContext;
import com.flagsmith.flagengine.SegmentContext;
import com.flagsmith.flagengine.SegmentResult;
import com.flagsmith.flagengine.Segments;
import com.flagsmith.flagengine.segments.SegmentEvaluator;
import com.flagsmith.flagengine.utils.Hashing;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class Engine {
    public static EvaluationResult getEvaluationResult(EvaluationContext context) {
        context = Engine.getEnrichedEvaluationContext(context);
        SegmentEvaluationResult segmentEvaluationResult = Engine.evaluateSegments(context);
        Flags flags = Engine.evaluateFeatures(context, segmentEvaluationResult.getSegmentFeatureContexts());
        return new EvaluationResult().withFlags(flags).withSegments(segmentEvaluationResult.getSegments());
    }

    private static EvaluationContext getEnrichedEvaluationContext(EvaluationContext context) {
        IdentityContext identity = context.getIdentity();
        if (identity != null && StringUtils.isEmpty((CharSequence)identity.getKey())) {
            String identityKey = context.getEnvironment().getKey() + "_" + identity.getIdentifier();
            context = new EvaluationContext(context).withIdentity(new IdentityContext(identity).withKey(identityKey));
        }
        return context;
    }

    private static SegmentEvaluationResult evaluateSegments(EvaluationContext context) {
        ArrayList<SegmentResult> segments = new ArrayList<SegmentResult>();
        HashMap<String, ImmutablePair<String, FeatureContext>> segmentFeatureContexts = new HashMap<String, ImmutablePair<String, FeatureContext>>();
        Segments contextSegments = context.getSegments();
        if (contextSegments != null) {
            for (SegmentContext segmentContext : contextSegments.getAdditionalProperties().values()) {
                if (!SegmentEvaluator.isContextInSegment(context, segmentContext).booleanValue()) continue;
                segments.add(new SegmentResult().withName(segmentContext.getName()).withMetadata(segmentContext.getMetadata()));
                List<FeatureContext> segmentOverrides = segmentContext.getOverrides();
                if (segmentOverrides == null) continue;
                for (FeatureContext featureContext : segmentOverrides) {
                    String featureName = featureContext.getName();
                    if (segmentFeatureContexts.containsKey(featureName)) {
                        ImmutablePair<String, FeatureContext> existing = segmentFeatureContexts.get(featureName);
                        FeatureContext existingFeatureContext = (FeatureContext)existing.getRight();
                        Double existingPriority = existingFeatureContext.getPriority() == null ? Double.POSITIVE_INFINITY : existingFeatureContext.getPriority();
                        Double featurePriority = featureContext.getPriority() == null ? Double.POSITIVE_INFINITY : featureContext.getPriority();
                        if (existingPriority < featurePriority) continue;
                    }
                    segmentFeatureContexts.put(featureName, (ImmutablePair<String, FeatureContext>)new ImmutablePair((Object)segmentContext.getName(), (Object)featureContext));
                }
            }
        }
        return new SegmentEvaluationResult(segments, segmentFeatureContexts);
    }

    private static Flags evaluateFeatures(EvaluationContext context, HashMap<String, ImmutablePair<String, FeatureContext>> segmentFeatureContexts) {
        String identityKey;
        Features contextFeatures = context.getFeatures();
        Flags flags = new Flags();
        String string = identityKey = context.getIdentity() != null ? context.getIdentity().getKey() : null;
        if (contextFeatures != null) {
            for (FeatureContext featureContext : contextFeatures.getAdditionalProperties().values()) {
                Object reason;
                if (segmentFeatureContexts.containsKey(featureContext.getName())) {
                    ImmutablePair<String, FeatureContext> segmentNameFeaturePair = segmentFeatureContexts.get(featureContext.getName());
                    featureContext = (FeatureContext)segmentNameFeaturePair.getRight();
                    reason = "TARGETING_MATCH; segment=" + (String)segmentNameFeaturePair.getLeft();
                } else {
                    reason = "DEFAULT";
                }
                flags.setAdditionalProperty(featureContext.getName(), Engine.getFlagResultFromFeatureContext(featureContext, identityKey, (String)reason));
            }
        }
        return flags;
    }

    private static FlagResult getFlagResultFromFeatureContext(FeatureContext featureContext, String identityKey, String reason) {
        List<FeatureValue> variants;
        if (identityKey != null && (variants = featureContext.getVariants()) != null) {
            Float percentageValue = Hashing.getInstance().getHashedPercentageForObjectIds(List.of(featureContext.getKey(), identityKey));
            Float startPercentage = Float.valueOf(0.0f);
            ArrayList<FeatureValue> sortedVariants = new ArrayList<FeatureValue>(variants);
            sortedVariants.sort((a, b) -> {
                Double priority = a.getPriority();
                Double comparedPriority = b.getPriority();
                return priority.compareTo(comparedPriority);
            });
            for (FeatureValue variant : sortedVariants) {
                Double weight = variant.getWeight();
                Float limit = Float.valueOf(startPercentage.floatValue() + weight.floatValue());
                if (startPercentage.floatValue() <= percentageValue.floatValue() && percentageValue.floatValue() < limit.floatValue()) {
                    return new FlagResult().withEnabled(featureContext.getEnabled()).withName(featureContext.getName()).withValue(variant.getValue()).withReason("SPLIT; weight=" + BigDecimal.valueOf(weight).stripTrailingZeros().toPlainString()).withMetadata(featureContext.getMetadata());
                }
                startPercentage = limit;
            }
        }
        return new FlagResult().withEnabled(featureContext.getEnabled()).withName(featureContext.getName()).withValue(featureContext.getValue()).withReason(reason).withMetadata(featureContext.getMetadata());
    }

    private static class SegmentEvaluationResult {
        List<SegmentResult> segments;
        HashMap<String, ImmutablePair<String, FeatureContext>> segmentFeatureContexts;

        public SegmentEvaluationResult(List<SegmentResult> segments, HashMap<String, ImmutablePair<String, FeatureContext>> segmentFeatureContexts) {
            this.segments = segments;
            this.segmentFeatureContexts = segmentFeatureContexts;
        }

        public List<SegmentResult> getSegments() {
            return this.segments;
        }

        public HashMap<String, ImmutablePair<String, FeatureContext>> getSegmentFeatureContexts() {
            return this.segmentFeatureContexts;
        }
    }
}

