/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.flagsmith.flagengine.EnvironmentContext;
import com.flagsmith.flagengine.Features;
import com.flagsmith.flagengine.IdentityContext;
import com.flagsmith.flagengine.Segments;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"environment", "identity", "segments", "features"})
public class EvaluationContext {
    @JsonProperty(value="environment")
    @JsonPropertyDescription(value="Represents an environment context for feature flag evaluation.")
    private EnvironmentContext environment;
    @JsonProperty(value="identity")
    @JsonPropertyDescription(value="Identity context used for identity-based evaluation.")
    private IdentityContext identity = null;
    @JsonProperty(value="segments")
    @JsonPropertyDescription(value="Segments applicable to the evaluation context.")
    private Segments segments;
    @JsonProperty(value="features")
    @JsonPropertyDescription(value="Features to be evaluated in the context.")
    private Features features;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public EvaluationContext() {
    }

    public EvaluationContext(EvaluationContext source) {
        this.environment = source.environment;
        this.identity = source.identity;
        this.segments = source.segments;
        this.features = source.features;
    }

    public EvaluationContext(EnvironmentContext environment, IdentityContext identity, Segments segments, Features features) {
        this.environment = environment;
        this.identity = identity;
        this.segments = segments;
        this.features = features;
    }

    @JsonProperty(value="environment")
    public EnvironmentContext getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    public void setEnvironment(EnvironmentContext environment) {
        this.environment = environment;
    }

    public EvaluationContext withEnvironment(EnvironmentContext environment) {
        this.environment = environment;
        return this;
    }

    @JsonProperty(value="identity")
    public IdentityContext getIdentity() {
        return this.identity;
    }

    @JsonProperty(value="identity")
    public void setIdentity(IdentityContext identity) {
        this.identity = identity;
    }

    public EvaluationContext withIdentity(IdentityContext identity) {
        this.identity = identity;
        return this;
    }

    @JsonProperty(value="segments")
    public Segments getSegments() {
        return this.segments;
    }

    @JsonProperty(value="segments")
    public void setSegments(Segments segments) {
        this.segments = segments;
    }

    public EvaluationContext withSegments(Segments segments) {
        this.segments = segments;
        return this;
    }

    @JsonProperty(value="features")
    public Features getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    public void setFeatures(Features features) {
        this.features = features;
    }

    public EvaluationContext withFeatures(Features features) {
        this.features = features;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EvaluationContext withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EvaluationContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("environment");
        sb.append('=');
        sb.append(this.environment == null ? "<null>" : this.environment);
        sb.append(',');
        sb.append("identity");
        sb.append('=');
        sb.append(this.identity == null ? "<null>" : this.identity);
        sb.append(',');
        sb.append("segments");
        sb.append('=');
        sb.append(this.segments == null ? "<null>" : this.segments);
        sb.append(',');
        sb.append("features");
        sb.append('=');
        sb.append(this.features == null ? "<null>" : this.features);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.features == null ? 0 : this.features.hashCode());
        result = result * 31 + (this.environment == null ? 0 : this.environment.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.identity == null ? 0 : this.identity.hashCode());
        result = result * 31 + (this.segments == null ? 0 : this.segments.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EvaluationContext)) {
            return false;
        }
        EvaluationContext rhs = (EvaluationContext)other;
        return (this.features == rhs.features || this.features != null && this.features.equals(rhs.features)) && (this.environment == rhs.environment || this.environment != null && this.environment.equals(rhs.environment)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.identity == rhs.identity || this.identity != null && this.identity.equals(rhs.identity)) && (this.segments == rhs.segments || this.segments != null && this.segments.equals(rhs.segments));
    }
}

