/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"value", "weight", "priority"})
public class FeatureValue {
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="The value of the feature.")
    private Object value;
    @JsonProperty(value="weight")
    @JsonPropertyDescription(value="The weight of the feature value variant, as a percentage number (i.e. 100.0).")
    private Double weight;
    @JsonProperty(value="priority")
    @JsonPropertyDescription(value="Priority of the feature flag variant. Lower values indicate a higher priority when multiple variants apply to the same context key.")
    private Double priority;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public FeatureValue() {
    }

    public FeatureValue(FeatureValue source) {
        this.value = source.value;
        this.weight = source.weight;
        this.priority = source.priority;
    }

    public FeatureValue(Object value, Double weight, Double priority) {
        this.value = value;
        this.weight = weight;
        this.priority = priority;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(Object value) {
        this.value = value;
    }

    public FeatureValue withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="weight")
    public Double getWeight() {
        return this.weight;
    }

    @JsonProperty(value="weight")
    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public FeatureValue withWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    @JsonProperty(value="priority")
    public Double getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority(Double priority) {
        this.priority = priority;
    }

    public FeatureValue withPriority(Double priority) {
        this.priority = priority;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FeatureValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FeatureValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("weight");
        sb.append('=');
        sb.append(this.weight == null ? "<null>" : this.weight);
        sb.append(',');
        sb.append("priority");
        sb.append('=');
        sb.append(this.priority == null ? "<null>" : this.priority);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.weight == null ? 0 : this.weight.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.priority == null ? 0 : this.priority.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FeatureValue)) {
            return false;
        }
        FeatureValue rhs = (FeatureValue)other;
        return (this.weight == rhs.weight || this.weight != null && this.weight.equals(rhs.weight)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.priority == rhs.priority || this.priority != null && this.priority.equals(rhs.priority)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }
}

