/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.flagsmith.flagengine.Traits;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"identifier", "key", "traits"})
public class IdentityContext {
    @JsonProperty(value="identifier")
    @JsonPropertyDescription(value="A unique identifier for an identity, used for segment and multivariate feature flag targeting, and displayed in the Flagsmith UI.")
    private String identifier;
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="Key used when selecting a value for a multivariate feature, or for % split segmentation. Set to an internal identifier or a composite value based on the environment key and identifier, depending on Flagsmith implementation.")
    private String key;
    @JsonProperty(value="traits")
    @JsonPropertyDescription(value="A map of traits associated with the identity, where the key is the trait name and the value is the trait value.")
    private Traits traits;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public IdentityContext() {
    }

    public IdentityContext(IdentityContext source) {
        this.identifier = source.identifier;
        this.key = source.key;
        this.traits = source.traits;
    }

    public IdentityContext(String identifier, String key) {
        this.identifier = identifier;
        this.key = key;
    }

    public IdentityContext(String identifier, String key, Traits traits) {
        this.identifier = identifier;
        this.key = key;
        this.traits = traits;
    }

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public IdentityContext withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public IdentityContext withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty(value="traits")
    public Traits getTraits() {
        return this.traits;
    }

    @JsonProperty(value="traits")
    public void setTraits(Traits traits) {
        this.traits = traits;
    }

    public IdentityContext withTraits(Traits traits) {
        this.traits = traits;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public IdentityContext withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IdentityContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("identifier");
        sb.append('=');
        sb.append(this.identifier == null ? "<null>" : this.identifier);
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(this.key == null ? "<null>" : this.key);
        sb.append(',');
        sb.append("traits");
        sb.append('=');
        sb.append(this.traits == null ? "<null>" : this.traits);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }
}

