/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.flagsmith.flagengine.segments.constants.SegmentConditions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;

public class SegmentCondition {
    private SegmentConditions operator;
    private Object value;
    private String property;

    public SegmentCondition() {
    }

    public SegmentCondition(SegmentCondition source) {
        this.operator = source.operator;
        this.value = source.value;
        this.property = source.property;
    }

    public SegmentCondition(SegmentConditions operator, String property, Object value) {
        this.operator = operator;
        this.property = property;
        this.value = value;
    }

    @JsonSetter(value="value")
    public void setValue(JsonNode node) {
        if (node.isArray()) {
            ArrayNode arr = (ArrayNode)node;
            List<String> values = StreamSupport.stream(arr.spliterator(), false).peek(el -> {
                if (!el.isTextual()) {
                    throw new IllegalArgumentException("Array elements must be strings");
                }
            }).map(JsonNode::asText).collect(Collectors.toList());
            this.setValue(values);
        } else if (node.isTextual()) {
            this.setValue(node.asText());
        } else {
            throw new IllegalArgumentException("Value must be a String or List of Strings");
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(List<String> value) {
        if (this.operator != SegmentConditions.IN) {
            throw new IllegalArgumentException("List value can only be set for IN operator");
        }
        this.value = value;
    }

    public SegmentCondition withOperator(SegmentConditions operator) {
        this.operator = operator;
        return this;
    }

    public SegmentCondition withProperty(String property) {
        this.property = property;
        return this;
    }

    public SegmentCondition withValue(Object value) {
        this.value = value;
        return this;
    }

    public SegmentCondition withValue(String value) {
        this.value = value;
        return this;
    }

    public SegmentCondition withValue(List<String> value) {
        if (this.operator != SegmentConditions.IN) {
            throw new IllegalArgumentException("List value can only be set for IN operator");
        }
        this.value = value;
        return this;
    }

    @Generated
    public SegmentConditions getOperator() {
        return this.operator;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public void setOperator(SegmentConditions operator) {
        this.operator = operator;
    }

    @Generated
    public void setProperty(String property) {
        this.property = property;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentCondition)) {
            return false;
        }
        SegmentCondition other = (SegmentCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SegmentConditions this$operator = this.getOperator();
        SegmentConditions other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        return !(this$property == null ? other$property != null : !this$property.equals(other$property));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SegmentConditions $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SegmentCondition(operator=" + String.valueOf((Object)this.getOperator()) + ", value=" + String.valueOf(this.getValue()) + ", property=" + this.getProperty() + ")";
    }
}

