/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.flagsmith.flagengine.FeatureContext;
import com.flagsmith.flagengine.SegmentRule;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"key", "name", "rules", "overrides", "metadata"})
public class SegmentContext {
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="Unique segment key used for % split segmentation.")
    private String key;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the segment.")
    private String name;
    @JsonProperty(value="rules")
    @JsonPropertyDescription(value="Rules that define the segment.")
    private List<SegmentRule> rules = new ArrayList<SegmentRule>();
    @JsonProperty(value="overrides")
    @JsonPropertyDescription(value="Feature overrides for the segment.")
    private List<FeatureContext> overrides = new ArrayList<FeatureContext>();
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Additional metadata associated with the segment.")
    private Map<String, Object> metadata;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public SegmentContext() {
    }

    public SegmentContext(SegmentContext source) {
        this.key = source.key;
        this.name = source.name;
        this.rules = source.rules;
        this.overrides = source.overrides;
        this.metadata = source.metadata;
    }

    public SegmentContext(String key, String name, List<SegmentRule> rules, List<FeatureContext> overrides, Map<String, Object> metadata) {
        this.key = key;
        this.name = name;
        this.rules = rules;
        this.overrides = overrides;
        this.metadata = metadata;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public SegmentContext withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public SegmentContext withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="rules")
    public List<SegmentRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<SegmentRule> rules) {
        this.rules = rules;
    }

    public SegmentContext withRules(List<SegmentRule> rules) {
        this.rules = rules;
        return this;
    }

    @JsonProperty(value="overrides")
    public List<FeatureContext> getOverrides() {
        return this.overrides;
    }

    @JsonProperty(value="overrides")
    public void setOverrides(List<FeatureContext> overrides) {
        this.overrides = overrides;
    }

    public SegmentContext withOverrides(List<FeatureContext> overrides) {
        this.overrides = overrides;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public SegmentContext withMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SegmentContext withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SegmentContext.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("key");
        sb.append('=');
        sb.append(this.key == null ? "<null>" : this.key);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(this.rules == null ? "<null>" : this.rules);
        sb.append(',');
        sb.append("overrides");
        sb.append('=');
        sb.append(this.overrides == null ? "<null>" : this.overrides);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.rules == null ? 0 : this.rules.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.overrides == null ? 0 : this.overrides.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SegmentContext)) {
            return false;
        }
        SegmentContext rhs = (SegmentContext)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.rules == rhs.rules || this.rules != null && this.rules.equals(rhs.rules)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.overrides == rhs.overrides || this.overrides != null && this.overrides.equals(rhs.overrides)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.key == rhs.key || this.key != null && this.key.equals(rhs.key));
    }
}

