/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.mappers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.flagsmith.MapperFactory;
import com.flagsmith.flagengine.EnvironmentContext;
import com.flagsmith.flagengine.EvaluationContext;
import com.flagsmith.flagengine.FeatureContext;
import com.flagsmith.flagengine.FeatureValue;
import com.flagsmith.flagengine.Features;
import com.flagsmith.flagengine.FlagResult;
import com.flagsmith.flagengine.IdentityContext;
import com.flagsmith.flagengine.SegmentCondition;
import com.flagsmith.flagengine.SegmentContext;
import com.flagsmith.flagengine.SegmentRule;
import com.flagsmith.flagengine.Segments;
import com.flagsmith.flagengine.Traits;
import com.flagsmith.flagengine.segments.constants.SegmentConditions;
import com.flagsmith.models.FeatureMetadata;
import com.flagsmith.models.Flag;
import com.flagsmith.models.SegmentMetadata;
import com.flagsmith.models.TraitModel;
import com.flagsmith.models.environments.EnvironmentModel;
import com.flagsmith.models.features.FeatureModel;
import com.flagsmith.models.features.FeatureSegmentModel;
import com.flagsmith.models.features.FeatureStateModel;
import com.flagsmith.models.features.MultivariateFeatureStateValueModel;
import com.flagsmith.models.identities.IdentityModel;
import com.flagsmith.models.projects.ProjectModel;
import com.flagsmith.models.segments.SegmentConditionModel;
import com.flagsmith.models.segments.SegmentModel;
import com.flagsmith.models.segments.SegmentRuleModel;
import com.flagsmith.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class EngineMappers {
    public static Flag mapFlagResultToFlag(FlagResult flagResult) {
        FeatureMetadata metadata = (FeatureMetadata)MapperFactory.getMapper().convertValue(flagResult.getMetadata(), FeatureMetadata.class);
        Flag flag = new Flag();
        flag.setFeatureId(metadata.getFlagsmithId());
        flag.setFeatureName(flagResult.getName());
        flag.setValue(flagResult.getValue());
        flag.setEnabled(flagResult.getEnabled());
        return flag;
    }

    public static EvaluationContext mapContextAndIdentityDataToContext(EvaluationContext context, String identifier, Map<String, Object> traits) {
        IdentityContext identityContext = new IdentityContext().withIdentifier(identifier);
        if (traits != null && !traits.isEmpty()) {
            Traits identityTraits = new Traits();
            for (TraitModel traitModel : ModelUtils.getTraitModelsFromTraitMap(traits)) {
                identityTraits.setAdditionalProperty(traitModel.getTraitKey(), traitModel.getTraitValue());
            }
            identityContext.setTraits(identityTraits);
        }
        return new EvaluationContext(context).withIdentity(identityContext);
    }

    public static EvaluationContext mapEnvironmentDocumentToContext(JsonNode environmentDocument) {
        return EngineMappers.mapEnvironmentToContext((EnvironmentModel)MapperFactory.getMapper().convertValue((Object)environmentDocument, EnvironmentModel.class));
    }

    public static EvaluationContext mapEnvironmentToContext(EnvironmentModel environmentModel) {
        EnvironmentContext environmentContext = new EnvironmentContext().withKey(environmentModel.getApiKey()).withName(environmentModel.getName());
        HashMap<String, FeatureContext> features = new HashMap<String, FeatureContext>();
        for (FeatureStateModel featureState : environmentModel.getFeatureStates()) {
            FeatureContext featureContext = EngineMappers.mapFeatureStateToFeatureContext(featureState);
            features.put(featureContext.getName(), featureContext);
        }
        HashMap<String, SegmentContext> segments = new HashMap<String, SegmentContext>();
        ProjectModel project = environmentModel.getProject();
        for (SegmentModel segment : project.getSegments()) {
            String segmentKey = String.valueOf(segment.getId());
            segments.put(segmentKey, EngineMappers.mapSegmentToSegmentContext(segment));
        }
        Map<String, SegmentContext> identityOverrideSegments = EngineMappers.mapIdentityOverridesToSegments(environmentModel.getIdentityOverrides());
        segments.putAll(identityOverrideSegments);
        EvaluationContext evaluationContext = new EvaluationContext().withEnvironment(environmentContext);
        Features featuresObj = new Features();
        for (Map.Entry entry : features.entrySet()) {
            featuresObj.withAdditionalProperty((String)entry.getKey(), (FeatureContext)entry.getValue());
        }
        evaluationContext.withFeatures(featuresObj);
        Segments segmentsObj = new Segments();
        for (Map.Entry entry : segments.entrySet()) {
            segmentsObj.withAdditionalProperty((String)entry.getKey(), (SegmentContext)entry.getValue());
        }
        evaluationContext.withSegments(segmentsObj);
        return evaluationContext;
    }

    private static Map<String, SegmentContext> mapIdentityOverridesToSegments(List<IdentityModel> identityOverrides) {
        ArrayList<FeatureContext> overridesKey;
        HashMap<List, List> featuresToIdentifiers = new HashMap<List, List>();
        for (IdentityModel identityOverride : identityOverrides) {
            List<FeatureStateModel> identityFeatures = identityOverride.getIdentityFeatures();
            if (identityFeatures == null || identityFeatures.isEmpty()) continue;
            overridesKey = new ArrayList();
            ArrayList sortedFeatures = new ArrayList();
            identityFeatures.forEach(sortedFeatures::add);
            sortedFeatures.sort((a, b) -> a.getFeature().getName().compareTo(b.getFeature().getName()));
            for (FeatureStateModel featureState : sortedFeatures) {
                FeatureModel feature = featureState.getFeature();
                FeatureContext featureContext = new FeatureContext().withKey("").withName(feature.getName()).withEnabled(featureState.getEnabled()).withValue(featureState.getValue()).withPriority(Double.NEGATIVE_INFINITY).withMetadata(EngineMappers.mapFeatureStateToFeatureMetadata(featureState));
                overridesKey.add(featureContext);
            }
            String identifier = identityOverride.getIdentifier();
            featuresToIdentifiers.computeIfAbsent(overridesKey, k -> new ArrayList()).add(identifier);
        }
        HashMap<String, SegmentContext> segmentContexts = new HashMap<String, SegmentContext>();
        for (Map.Entry entry : featuresToIdentifiers.entrySet()) {
            overridesKey = (List)entry.getKey();
            List identifiers = (List)entry.getValue();
            String segmentKey = EngineMappers.getVirtualSegmentKey(overridesKey);
            SegmentCondition identifierCondition = new SegmentCondition().withProperty("$.identity.identifier").withOperator(SegmentConditions.IN).withValue(identifiers);
            SegmentRule segmentRule = new SegmentRule().withType(SegmentRule.Type.ALL).withConditions(List.of(identifierCondition));
            ArrayList<FeatureContext> overrides = new ArrayList<FeatureContext>();
            for (FeatureContext featureContext : overridesKey) {
                FeatureContext override = new FeatureContext(featureContext).withKey("");
                overrides.add(override);
            }
            SegmentMetadata metadata = new SegmentMetadata();
            metadata.setSource(SegmentMetadata.Source.IDENTITY_OVERRIDES);
            Map<String, Object> metadataMap = EngineMappers.mapSegmentMetadataToMetadataMap(metadata);
            SegmentContext segmentContext = new SegmentContext().withKey("").withName("identity_overrides").withRules(List.of(segmentRule)).withOverrides(overrides).withMetadata(metadataMap);
            segmentContexts.put(segmentKey, segmentContext);
        }
        return segmentContexts;
    }

    private static List<SegmentRule> mapEnvironmentDocumentRulesToContextRules(List<SegmentRuleModel> rules) {
        ArrayList<SegmentRule> segmentRules = new ArrayList<SegmentRule>();
        for (SegmentRuleModel rule : rules) {
            ArrayList<SegmentCondition> conditions = new ArrayList<SegmentCondition>();
            if (rule.getConditions() != null) {
                for (SegmentConditionModel condition : rule.getConditions()) {
                    SegmentCondition segmentCondition = new SegmentCondition().withProperty(condition.getProperty()).withOperator(condition.getOperator()).withValue(condition.getValue());
                    conditions.add(segmentCondition);
                }
            }
            List<SegmentRule> subRules = EngineMappers.mapEnvironmentDocumentRulesToContextRules(rule.getRules());
            SegmentRule segmentRule = new SegmentRule().withType(SegmentRule.Type.fromValue(rule.getType())).withConditions(conditions).withRules(subRules);
            segmentRules.add(segmentRule);
        }
        return segmentRules;
    }

    private static List<FeatureContext> mapEnvironmentDocumentFeatureStatesToFeatureContexts(List<FeatureStateModel> featureStates) {
        ArrayList<FeatureContext> featureContexts = new ArrayList<FeatureContext>();
        if (featureStates != null) {
            for (FeatureStateModel featureState : featureStates) {
                FeatureContext featureContext = EngineMappers.mapFeatureStateToFeatureContext(featureState);
                featureContexts.add(featureContext);
            }
        }
        return featureContexts;
    }

    private static String getFeatureStateKey(FeatureStateModel featureState) {
        Integer djangoId = featureState.getDjangoId();
        if (djangoId != null) {
            return djangoId.toString();
        }
        return featureState.getFeaturestateUuid();
    }

    private static double getMultivariateFeatureValuePriority(MultivariateFeatureStateValueModel multivariateValue) {
        if (multivariateValue.getId() != null) {
            return multivariateValue.getId().intValue();
        }
        UUID mvFsValueUuid = UUID.fromString(multivariateValue.getMvFsValueUuid());
        return mvFsValueUuid.getMostSignificantBits() & Long.MAX_VALUE;
    }

    private static FeatureContext mapFeatureStateToFeatureContext(FeatureStateModel featureState) {
        Double priority;
        FeatureContext featureContext = new FeatureContext().withKey(EngineMappers.getFeatureStateKey(featureState)).withName(featureState.getFeature().getName()).withEnabled(featureState.getEnabled()).withValue(featureState.getValue()).withMetadata(EngineMappers.mapFeatureStateToFeatureMetadata(featureState));
        ArrayList<FeatureValue> variants = new ArrayList<FeatureValue>();
        for (MultivariateFeatureStateValueModel mvValue : featureState.getMultivariateFeatureStateValues()) {
            FeatureValue variant = new FeatureValue().withValue(mvValue.getMultivariateFeatureOption().getValue()).withWeight(mvValue.getPercentageAllocation().doubleValue()).withPriority(EngineMappers.getMultivariateFeatureValuePriority(mvValue));
            variants.add(variant);
        }
        featureContext.setVariants(variants);
        FeatureSegmentModel featureSegment = featureState.getFeatureSegment();
        if (featureSegment != null && (priority = Double.valueOf(featureSegment.getPriority().intValue())) != null) {
            featureContext.withPriority(priority);
        }
        return featureContext;
    }

    private static Map<String, Object> mapFeatureStateToFeatureMetadata(FeatureStateModel featureState) {
        FeatureMetadata metadata = new FeatureMetadata();
        metadata.setFlagsmithId(featureState.getFeature().getId());
        return (Map)MapperFactory.getMapper().convertValue((Object)metadata, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private static SegmentContext mapSegmentToSegmentContext(SegmentModel segment) {
        List<SegmentRule> rules = EngineMappers.mapEnvironmentDocumentRulesToContextRules(segment.getRules());
        List<FeatureStateModel> segmentFeatureStates = segment.getFeatureStates();
        List<FeatureContext> overrides = EngineMappers.mapEnvironmentDocumentFeatureStatesToFeatureContexts(segmentFeatureStates);
        SegmentMetadata metadata = new SegmentMetadata();
        metadata.setSource(SegmentMetadata.Source.API);
        metadata.setFlagsmithId(segment.getId());
        Map<String, Object> metadataMap = EngineMappers.mapSegmentMetadataToMetadataMap(metadata);
        String segmentKey = String.valueOf(segment.getId());
        return new SegmentContext().withKey(segmentKey).withName(segment.getName()).withRules(rules).withOverrides(overrides).withMetadata(metadataMap);
    }

    private static String getVirtualSegmentKey(List<FeatureContext> featureContexts) {
        StringBuilder keyBuilder = new StringBuilder();
        for (FeatureContext featureContext : featureContexts) {
            keyBuilder.append(featureContext.getName()).append(":").append(featureContext.getEnabled()).append(":").append(featureContext.getValue()).append("|");
        }
        return String.valueOf(keyBuilder.toString().hashCode());
    }

    private static Map<String, Object> mapSegmentMetadataToMetadataMap(SegmentMetadata metadata) {
        return (Map)MapperFactory.getMapper().convertValue((Object)metadata, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

