/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.threads;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.MapperFactory;
import com.flagsmith.interfaces.FlagsmithSdk;
import com.flagsmith.threads.RequestProcessor;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class AnalyticsProcessor {
    private final String analyticsEndpoint = "analytics/flags/";
    private Integer analyticsTimer = 10;
    private Map<String, LongAdder> analyticsData;
    private FlagsmithSdk api;
    private Long nextFlush;
    private AtomicBoolean isFlushing = new AtomicBoolean(false);
    private RequestProcessor requestProcessor;
    private HttpUrl analyticsUrl;
    FlagsmithLogger logger;

    public AnalyticsProcessor(OkHttpClient client) {
        this(null, client, null);
    }

    public AnalyticsProcessor(FlagsmithSdk api, OkHttpClient client) {
        this(api, client, new FlagsmithLogger());
    }

    public AnalyticsProcessor(FlagsmithSdk api, OkHttpClient client, FlagsmithLogger logger) {
        this(api, logger, new RequestProcessor(client, logger));
    }

    public AnalyticsProcessor(FlagsmithSdk api, FlagsmithLogger logger, RequestProcessor requestProcessor) {
        this.analyticsData = new ConcurrentHashMap<String, LongAdder>();
        this.requestProcessor = requestProcessor;
        this.logger = logger;
        this.nextFlush = Instant.now().getEpochSecond() + (long)this.analyticsTimer.intValue();
        this.api = api;
    }

    private RequestProcessor getRequestProcessor() {
        if (this.requestProcessor != null) {
            return this.requestProcessor;
        }
        return this.api.getRequestor();
    }

    private HttpUrl getAnalyticsUrl() {
        if (this.api != null) {
            this.analyticsUrl = this.api.getConfig().getBaseUri().newBuilder("analytics/flags/").build();
        }
        return this.analyticsUrl;
    }

    public void flush() {
        if (this.isFlushing.compareAndSet(false, true)) {
            String response;
            if (this.analyticsData.isEmpty()) {
                this.isFlushing.set(false);
                return;
            }
            try {
                ObjectMapper mapper = MapperFactory.getMapper();
                response = mapper.writeValueAsString(this.analyticsData);
                this.analyticsData.clear();
            }
            catch (JsonProcessingException jpe) {
                this.logger.error("Error parsing analytics data to JSON.", new Object[]{jpe});
                this.isFlushing.set(false);
                return;
            }
            MediaType json = MediaType.parse((String)"application/json; charset=utf-8");
            RequestBody body = RequestBody.create((MediaType)json, (String)response);
            Request request = this.api.newPostRequest(this.getAnalyticsUrl(), body);
            this.getRequestProcessor().executeAsync(request, Boolean.FALSE);
            this.setNextFlush();
            this.isFlushing.set(false);
        }
    }

    public void trackFeature(String featureName) {
        this.analyticsData.computeIfAbsent(featureName, k -> new LongAdder()).increment();
        if (this.nextFlush.compareTo(Instant.now().getEpochSecond()) < 0) {
            this.flush();
        }
    }

    private void setNextFlush() {
        this.nextFlush = Instant.now().getEpochSecond() + (long)this.analyticsTimer.intValue();
    }

    public void close() {
        this.requestProcessor.close();
    }

    @Generated
    public String getAnalyticsEndpoint() {
        return this.analyticsEndpoint;
    }

    @Generated
    public Integer getAnalyticsTimer() {
        return this.analyticsTimer;
    }

    @Generated
    public Map<String, LongAdder> getAnalyticsData() {
        return this.analyticsData;
    }

    @Generated
    public FlagsmithSdk getApi() {
        return this.api;
    }

    @Generated
    public Long getNextFlush() {
        return this.nextFlush;
    }

    @Generated
    public AtomicBoolean getIsFlushing() {
        return this.isFlushing;
    }

    @Generated
    public FlagsmithLogger getLogger() {
        return this.logger;
    }

    @Generated
    public void setApi(FlagsmithSdk api) {
        this.api = api;
    }

    @Generated
    public void setLogger(FlagsmithLogger logger) {
        this.logger = logger;
    }
}

