/*
 * Decompiled with CFR 0.152.
 */
package com.fullcontact.apilib.enrich;

import com.fullcontact.apilib.FullContactApi;
import com.fullcontact.apilib.FullContactException;
import com.fullcontact.apilib.auth.CredentialsProvider;
import com.fullcontact.apilib.auth.DefaultCredentialProvider;
import com.fullcontact.apilib.enrich.FCOkHttpInterceptor;
import com.fullcontact.apilib.models.Request.AudienceRequest;
import com.fullcontact.apilib.models.Request.CompanyRequest;
import com.fullcontact.apilib.models.Request.PersonRequest;
import com.fullcontact.apilib.models.Request.ResolveRequest;
import com.fullcontact.apilib.models.Request.TagsRequest;
import com.fullcontact.apilib.models.Response.AudienceResponse;
import com.fullcontact.apilib.models.Response.CompanyResponse;
import com.fullcontact.apilib.models.Response.CompanySearchResponse;
import com.fullcontact.apilib.models.Response.CompanySearchResponseList;
import com.fullcontact.apilib.models.Response.EmailVerificationResponse;
import com.fullcontact.apilib.models.Response.PersonResponse;
import com.fullcontact.apilib.models.Response.ResolveResponse;
import com.fullcontact.apilib.models.Response.ResolveResponseWithTags;
import com.fullcontact.apilib.models.Response.TagsResponse;
import com.fullcontact.apilib.models.enums.FCApiEndpoint;
import com.fullcontact.apilib.retry.DefaultRetryHandler;
import com.fullcontact.apilib.retry.RetryHandler;
import com.fullcontact.apilib.test.MockInterceptor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSink;
import retrofit2.Response;
import retrofit2.Retrofit;

public class FullContact
implements AutoCloseable {
    private final String baseUrl = "https://api.fullcontact.com/v3/";
    private final OkHttpClient httpClient;
    private final FullContactApi client;
    private final CredentialsProvider credentialsProvider;
    private final RetryHandler retryHandler;
    private final Map<String, String> headers;
    private final long connectTimeoutMillis;
    private final ScheduledExecutorService executor;
    private boolean isShutdown = false;
    private static final MediaType JSONMediaType = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Type companySearchResponseType = new TypeToken<ArrayList<CompanySearchResponse>>(){}.getType();
    private static final Gson gson = new Gson();

    public FullContact(CredentialsProvider credentialsProvider, Map<String, String> headers, long connectTimeoutMillis, RetryHandler retryHandler) {
        this.credentialsProvider = credentialsProvider;
        this.retryHandler = retryHandler;
        this.headers = headers != null ? Collections.unmodifiableMap(headers) : null;
        this.connectTimeoutMillis = connectTimeoutMillis > 0L ? connectTimeoutMillis : 3000L;
        this.httpClient = this.configureHTTPClientBuilder().build();
        this.client = (FullContactApi)this.configureRetrofit().create(FullContactApi.class);
        this.executor = new ScheduledThreadPoolExecutor(5);
    }

    protected OkHttpClient.Builder configureHTTPClientBuilder() {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        httpClientBuilder.addInterceptor(chain -> {
            Request.Builder requestBuilder = chain.request().newBuilder();
            requestBuilder.addHeader("Authorization", "Bearer " + this.credentialsProvider.getApiKey());
            requestBuilder.addHeader("Content-Type", "application/json");
            requestBuilder.addHeader("User-Agent", "FullContact_Java8_Client_V2.2.0");
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    if (entry.getKey().equalsIgnoreCase("authorization") || entry.getKey().equalsIgnoreCase("Content-Type") || entry.getKey().equalsIgnoreCase("User-Agent") || entry.getValue() == null) continue;
                    requestBuilder.addHeader(entry.getKey(), entry.getValue());
                }
            }
            Request request = requestBuilder.build();
            return chain.proceed(request);
        });
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.NONE);
        if (System.getProperty("FC_TEST_ENV", "").equals("FC_TEST")) {
            httpClientBuilder.addInterceptor((Interceptor)new MockInterceptor());
        }
        httpClientBuilder.addInterceptor((Interceptor)logging);
        httpClientBuilder.addNetworkInterceptor((Interceptor)new FCOkHttpInterceptor());
        httpClientBuilder.connectTimeout(this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        return httpClientBuilder;
    }

    protected Retrofit configureRetrofit() {
        return new Retrofit.Builder().baseUrl(this.baseUrl).client(this.httpClient).build();
    }

    public CompletableFuture<PersonResponse> enrich(PersonRequest personRequest) throws FullContactException {
        return this.enrich(personRequest, this.retryHandler);
    }

    public CompletableFuture<PersonResponse> enrich(PersonRequest personRequest, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)personRequest));
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.personEnrich(httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.PERSON_ENRICH);
        return responseCF.thenApply(FullContact::getPersonResponse);
    }

    public CompletableFuture<CompanyResponse> enrich(CompanyRequest companyRequest) throws FullContactException {
        return this.enrich(companyRequest, this.retryHandler);
    }

    public CompletableFuture<CompanyResponse> enrich(CompanyRequest companyRequest, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)companyRequest));
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.companyEnrich(httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.COMPANY_ENRICH);
        return responseCF.thenApply(FullContact::getCompanyResponse);
    }

    public CompletableFuture<CompanySearchResponseList> search(CompanyRequest companyRequest) throws FullContactException {
        return this.search(companyRequest, this.retryHandler);
    }

    public CompletableFuture<CompanySearchResponseList> search(CompanyRequest companyRequest, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)companyRequest));
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.companySearch(httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.COMPANY_SEARCH);
        return responseCF.thenApply(FullContact::getCompanySearchResponse);
    }

    public CompletableFuture<ResolveResponse> identityMap(ResolveRequest resolveRequest) throws FullContactException {
        return this.identityMap(resolveRequest, this.retryHandler);
    }

    public CompletableFuture<ResolveResponse> identityMap(ResolveRequest resolveRequest, RetryHandler retryHandler) throws FullContactException {
        resolveRequest.validateForIdentityMap();
        return this.resolveRequest(resolveRequest, retryHandler, FCApiEndpoint.IDENTITY_MAP);
    }

    public CompletableFuture<ResolveResponse> identityResolve(ResolveRequest resolveRequest) throws FullContactException {
        return this.identityResolve(resolveRequest, this.retryHandler);
    }

    public CompletableFuture<ResolveResponse> identityResolve(ResolveRequest resolveRequest, RetryHandler retryHandler) throws FullContactException {
        resolveRequest.validateForIdentityResolve();
        return this.resolveRequest(resolveRequest, retryHandler, FCApiEndpoint.IDENTITY_RESOLVE);
    }

    public CompletableFuture<ResolveResponseWithTags> identityResolveWithTags(ResolveRequest resolveRequest) throws FullContactException {
        return this.identityResolveWithTags(resolveRequest, this.retryHandler);
    }

    public CompletableFuture<ResolveResponseWithTags> identityResolveWithTags(ResolveRequest resolveRequest, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        resolveRequest.validateForIdentityResolve();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)resolveRequest));
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.identityResolveWithTags(true, httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.IDENTITY_RESOLVE_WITH_TAGS);
        return responseCF.thenApply(FullContact::getResolveResponseWithTags);
    }

    public CompletableFuture<ResolveResponse> identityDelete(ResolveRequest resolveRequest) throws FullContactException {
        return this.identityDelete(resolveRequest, this.retryHandler);
    }

    public CompletableFuture<ResolveResponse> identityDelete(ResolveRequest resolveRequest, RetryHandler retryHandler) throws FullContactException {
        resolveRequest.validateForIdentityDelete();
        return this.resolveRequest(resolveRequest, retryHandler, FCApiEndpoint.IDENTITY_DELETE);
    }

    protected CompletableFuture<ResolveResponse> resolveRequest(ResolveRequest resolveRequest, RetryHandler retryHandler, FCApiEndpoint fcApiEndpoint) throws FullContactException {
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture;
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)resolveRequest));
        switch (fcApiEndpoint) {
            case IDENTITY_MAP: {
                httpResponseCompletableFuture = this.client.identityMap(httpRequest);
                break;
            }
            case IDENTITY_RESOLVE: {
                httpResponseCompletableFuture = this.client.identityResolve(httpRequest);
                break;
            }
            case IDENTITY_DELETE: {
                httpResponseCompletableFuture = this.client.identityDelete(httpRequest);
                break;
            }
            default: {
                throw new FullContactException("Wrong API Endpoint provided for Resolve");
            }
        }
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, fcApiEndpoint);
        return responseCF.thenApply(FullContact::getResolveResponse);
    }

    public CompletableFuture<EmailVerificationResponse> emailVerification(String email) throws FullContactException {
        return this.emailVerification(email, this.retryHandler);
    }

    public CompletableFuture<EmailVerificationResponse> emailVerification(String email, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        if (email != null && !email.trim().isEmpty()) {
            CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
            RequestBody httpRequest = FullContact.buildHttpRequest(email);
            CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.emailVerification(email);
            this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.EMAIL_VERIFICATION);
            return responseCF.thenApply(FullContact::getEmailVerificationResponse);
        }
        throw new FullContactException("Email can't be empty");
    }

    public CompletableFuture<TagsResponse> tagsCreate(TagsRequest tagsRequest) throws FullContactException {
        return this.tagsCreate(tagsRequest, this.retryHandler);
    }

    public CompletableFuture<TagsResponse> tagsCreate(TagsRequest tagsRequest, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)tagsRequest));
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.tagsCreate(httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.TAGS_CREATE);
        return responseCF.thenApply(FullContact::getTagsResponse);
    }

    public CompletableFuture<TagsResponse> tagsGet(String recordId) throws FullContactException {
        return this.tagsGet(recordId, this.retryHandler);
    }

    public CompletableFuture<TagsResponse> tagsGet(String recordId, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest("{\"recordId\":\"" + recordId + "\"}");
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.tagsGet(httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.TAGS_GET);
        return responseCF.thenApply(FullContact::getTagsResponse);
    }

    public CompletableFuture<TagsResponse> tagsDelete(TagsRequest tagsRequest) throws FullContactException {
        return this.tagsDelete(tagsRequest, this.retryHandler);
    }

    public CompletableFuture<TagsResponse> tagsDelete(TagsRequest tagsRequest, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)tagsRequest));
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.tagsDelete(httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.TAGS_DELETE);
        return responseCF.thenApply(FullContact::getTagsResponse);
    }

    public CompletableFuture<AudienceResponse> audienceCreate(AudienceRequest audienceRequest) throws FullContactException {
        return this.audienceCreate(audienceRequest, this.retryHandler);
    }

    public CompletableFuture<AudienceResponse> audienceCreate(AudienceRequest audienceRequest, RetryHandler retryHandler) throws FullContactException {
        this.checkForShutdown();
        CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
        RequestBody httpRequest = FullContact.buildHttpRequest(gson.toJson((Object)audienceRequest));
        CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.audienceCreate(httpRequest);
        this.handleHttpResponse(httpRequest, retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.AUDIENCE_CREATE);
        return responseCF.thenApply(FullContact::getAudienceResponse);
    }

    public CompletableFuture<AudienceResponse> audienceDownload(String requestId) throws FullContactException {
        this.checkForShutdown();
        if (requestId != null && !requestId.trim().isEmpty()) {
            CompletableFuture<Response<ResponseBody>> responseCF = new CompletableFuture<Response<ResponseBody>>();
            RequestBody httpRequest = FullContact.buildHttpRequest(requestId);
            CompletableFuture<Response<ResponseBody>> httpResponseCompletableFuture = this.client.audienceDownload(requestId);
            this.handleHttpResponse(httpRequest, this.retryHandler, httpResponseCompletableFuture, responseCF, FCApiEndpoint.AUDIENCE_DOWNLOAD);
            return responseCF.thenApply(FullContact::getAudienceResponse);
        }
        throw new FullContactException("Email can't be empty");
    }

    protected void checkForShutdown() throws FullContactException {
        if (this.isShutdown) {
            throw new FullContactException("FullContact client is shutdown. Please create a new client");
        }
    }

    protected static RequestBody buildHttpRequest(String request) {
        return RequestBody.create((MediaType)JSONMediaType, (String)request);
    }

    protected void handleHttpResponse(RequestBody httpRequest, RetryHandler retryHandler, CompletableFuture<Response<ResponseBody>> currentResponse, CompletableFuture<Response<ResponseBody>> responseCF, FCApiEndpoint fcApiEndpoint) {
        currentResponse.handle((httpResponse, throwable) -> {
            if (throwable != null) {
                this.handleAutoRetry(responseCF, (Response<ResponseBody>)httpResponse, httpRequest, (Throwable)throwable, 0, retryHandler, fcApiEndpoint);
            } else if (httpResponse != null && !retryHandler.shouldRetry(httpResponse.code())) {
                responseCF.complete((Response<ResponseBody>)httpResponse);
            } else {
                this.handleAutoRetry(responseCF, (Response<ResponseBody>)httpResponse, httpRequest, null, 0, retryHandler, fcApiEndpoint);
            }
            return null;
        });
    }

    protected static PersonResponse getPersonResponse(Response<ResponseBody> response) {
        PersonResponse personResponse;
        if (response.isSuccessful() && response.body() != null) {
            personResponse = (PersonResponse)gson.fromJson(((ResponseBody)response.body()).charStream(), PersonResponse.class);
            if (response.code() == 200) {
                personResponse.message = "OK";
            }
        } else {
            personResponse = new PersonResponse();
            if (response.errorBody() != null) {
                personResponse = (PersonResponse)gson.fromJson(response.errorBody().charStream(), PersonResponse.class);
            } else {
                personResponse.message = response.message();
            }
        }
        personResponse.isSuccessful = response.code() == 200 || response.code() == 202 || response.code() == 404;
        personResponse.statusCode = response.code();
        return personResponse;
    }

    protected static CompanyResponse getCompanyResponse(Response<ResponseBody> response) {
        CompanyResponse companyResponse;
        if (response.isSuccessful() && response.body() != null) {
            companyResponse = (CompanyResponse)gson.fromJson(((ResponseBody)response.body()).charStream(), CompanyResponse.class);
            if (response.code() == 200) {
                companyResponse.message = "OK";
            }
        } else {
            companyResponse = new CompanyResponse();
            if (response.errorBody() != null) {
                companyResponse = (CompanyResponse)gson.fromJson(response.errorBody().charStream(), CompanyResponse.class);
            } else {
                companyResponse.message = response.message();
            }
        }
        companyResponse.isSuccessful = response.code() == 200 || response.code() == 202 || response.code() == 404;
        companyResponse.statusCode = response.code();
        return companyResponse;
    }

    protected static CompanySearchResponseList getCompanySearchResponse(Response<ResponseBody> response) {
        CompanySearchResponseList companySearchResponseList = new CompanySearchResponseList();
        if (response.body() != null) {
            if (response.code() == 200) {
                companySearchResponseList.companySearchResponses = (List)gson.fromJson(((ResponseBody)response.body()).charStream(), companySearchResponseType);
                companySearchResponseList.message = "OK";
                companySearchResponseList.isSuccessful = true;
            } else {
                companySearchResponseList = (CompanySearchResponseList)gson.fromJson(((ResponseBody)response.body()).charStream(), CompanySearchResponseList.class);
            }
        } else if (response.errorBody() != null) {
            companySearchResponseList = (CompanySearchResponseList)gson.fromJson(response.errorBody().charStream(), CompanySearchResponseList.class);
        } else {
            companySearchResponseList.message = response.message();
        }
        companySearchResponseList.isSuccessful = response.code() == 200 || response.code() == 202 || response.code() == 404;
        companySearchResponseList.statusCode = response.code();
        return companySearchResponseList;
    }

    protected static ResolveResponse getResolveResponse(Response<ResponseBody> response) {
        ResolveResponse resolveResponse;
        if (response.isSuccessful() && response.body() != null) {
            resolveResponse = (ResolveResponse)gson.fromJson(((ResponseBody)response.body()).charStream(), ResolveResponse.class);
            if (response.code() == 200 || response.code() == 204) {
                resolveResponse.message = "OK";
            }
        } else {
            resolveResponse = new ResolveResponse();
            if (response.errorBody() != null) {
                resolveResponse = (ResolveResponse)gson.fromJson(response.errorBody().charStream(), ResolveResponse.class);
            } else {
                resolveResponse.message = response.message();
            }
        }
        resolveResponse.statusCode = response.code();
        resolveResponse.isSuccessful = response.code() == 200 || response.code() == 204 || response.code() == 404;
        return resolveResponse;
    }

    protected static ResolveResponseWithTags getResolveResponseWithTags(Response<ResponseBody> response) {
        ResolveResponseWithTags resolveResponseWithTags;
        if (response.isSuccessful() && response.body() != null) {
            resolveResponseWithTags = (ResolveResponseWithTags)gson.fromJson(((ResponseBody)response.body()).charStream(), ResolveResponseWithTags.class);
            if (response.code() == 200 || response.code() == 204) {
                resolveResponseWithTags.message = "OK";
            }
        } else {
            resolveResponseWithTags = new ResolveResponseWithTags();
            if (response.errorBody() != null) {
                resolveResponseWithTags = (ResolveResponseWithTags)gson.fromJson(response.errorBody().charStream(), ResolveResponseWithTags.class);
            } else {
                resolveResponseWithTags.message = response.message();
            }
        }
        resolveResponseWithTags.statusCode = response.code();
        resolveResponseWithTags.isSuccessful = response.code() == 200 || response.code() == 204 || response.code() == 404;
        return resolveResponseWithTags;
    }

    protected static EmailVerificationResponse getEmailVerificationResponse(Response<ResponseBody> response) {
        EmailVerificationResponse emailVerificationResponse = new EmailVerificationResponse();
        if (response.isSuccessful() && response.body() != null) {
            emailVerificationResponse = (EmailVerificationResponse)gson.fromJson(((ResponseBody)response.body()).charStream(), EmailVerificationResponse.class);
            if (response.code() == 200) {
                emailVerificationResponse.message = "OK";
            }
        } else {
            emailVerificationResponse = new EmailVerificationResponse();
            if (response.errorBody() != null) {
                emailVerificationResponse = (EmailVerificationResponse)gson.fromJson(response.errorBody().charStream(), EmailVerificationResponse.class);
            } else {
                emailVerificationResponse.message = response.message();
            }
        }
        emailVerificationResponse.statusCode = response.code();
        emailVerificationResponse.isSuccessful = response.code() == 200 || response.code() == 202 || response.code() == 404;
        return emailVerificationResponse;
    }

    protected static TagsResponse getTagsResponse(Response<ResponseBody> response) {
        TagsResponse tagsResponse;
        if (response.isSuccessful() && response.body() != null) {
            tagsResponse = (TagsResponse)gson.fromJson(((ResponseBody)response.body()).charStream(), TagsResponse.class);
            if (response.code() == 200) {
                tagsResponse.message = "OK";
            }
        } else {
            tagsResponse = new TagsResponse();
            if (response.errorBody() != null) {
                tagsResponse = (TagsResponse)gson.fromJson(response.errorBody().charStream(), TagsResponse.class);
            } else {
                tagsResponse.message = response.message();
            }
        }
        tagsResponse.isSuccessful = response.code() == 200 || response.code() == 204 || response.code() == 404;
        tagsResponse.statusCode = response.code();
        return tagsResponse;
    }

    protected static AudienceResponse getAudienceResponse(Response<ResponseBody> response) {
        AudienceResponse audienceResponse;
        if (response.isSuccessful() && response.body() != null) {
            String contentType = response.headers().get("Content-Type");
            audienceResponse = contentType != null && contentType.equals("application/octet-stream") ? new AudienceResponse(((ResponseBody)response.body()).bytes()) : (AudienceResponse)gson.fromJson(((ResponseBody)response.body()).charStream(), AudienceResponse.class);
            if (response.code() == 200) {
                audienceResponse.message = "OK";
            }
        } else {
            audienceResponse = new AudienceResponse();
            if (response.errorBody() != null) {
                audienceResponse = (AudienceResponse)gson.fromJson(response.errorBody().charStream(), AudienceResponse.class);
            } else {
                audienceResponse.message = response.message();
            }
        }
        audienceResponse.isSuccessful = response.code() == 200 || response.code() == 202 || response.code() == 404;
        audienceResponse.statusCode = response.code();
        return audienceResponse;
    }

    protected void handleAutoRetry(CompletableFuture<Response<ResponseBody>> responseCF, Response<ResponseBody> httpResponse, RequestBody httpRequest, Throwable throwable, int retryAttemptsDone, RetryHandler retryHandler, FCApiEndpoint fcApiEndpoint) {
        if (retryAttemptsDone < Math.min(retryHandler.getRetryAttempts(), 5)) {
            int finalRetryAttemptsDone = ++retryAttemptsDone;
            this.executor.schedule(() -> {
                CompletableFuture<Response<ResponseBody>> retryCF = null;
                switch (fcApiEndpoint) {
                    case PERSON_ENRICH: {
                        retryCF = this.client.personEnrich(httpRequest);
                        break;
                    }
                    case COMPANY_ENRICH: {
                        retryCF = this.client.companyEnrich(httpRequest);
                        break;
                    }
                    case COMPANY_SEARCH: {
                        retryCF = this.client.companySearch(httpRequest);
                        break;
                    }
                    case IDENTITY_MAP: {
                        retryCF = this.client.identityMap(httpRequest);
                        break;
                    }
                    case IDENTITY_RESOLVE: {
                        retryCF = this.client.identityResolve(httpRequest);
                        break;
                    }
                    case IDENTITY_RESOLVE_WITH_TAGS: {
                        retryCF = this.client.identityResolveWithTags(true, httpRequest);
                        break;
                    }
                    case IDENTITY_DELETE: {
                        retryCF = this.client.identityDelete(httpRequest);
                        break;
                    }
                    case TAGS_CREATE: {
                        retryCF = this.client.tagsCreate(httpRequest);
                        break;
                    }
                    case TAGS_GET: {
                        retryCF = this.client.tagsGet(httpRequest);
                        break;
                    }
                    case TAGS_DELETE: {
                        retryCF = this.client.tagsDelete(httpRequest);
                        break;
                    }
                    case AUDIENCE_CREATE: {
                        retryCF = this.client.audienceCreate(httpRequest);
                        break;
                    }
                    case AUDIENCE_DOWNLOAD: {
                        try {
                            Buffer buffer = new Buffer();
                            httpRequest.writeTo((BufferedSink)buffer);
                            retryCF = this.client.audienceDownload(buffer.readUtf8());
                        }
                        catch (IOException buffer) {}
                        break;
                    }
                    case EMAIL_VERIFICATION: {
                        try {
                            Buffer buffer = new Buffer();
                            httpRequest.writeTo((BufferedSink)buffer);
                            retryCF = this.client.emailVerification(buffer.readUtf8());
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                retryCF.handle((retryResponse, retryThrowable) -> {
                    if (retryThrowable != null) {
                        this.handleAutoRetry(responseCF, (Response<ResponseBody>)retryResponse, httpRequest, (Throwable)retryThrowable, finalRetryAttemptsDone, retryHandler, fcApiEndpoint);
                    } else if (retryResponse != null && !retryHandler.shouldRetry(retryResponse.code())) {
                        responseCF.complete((Response<ResponseBody>)retryResponse);
                    } else {
                        this.handleAutoRetry(responseCF, (Response<ResponseBody>)retryResponse, httpRequest, null, finalRetryAttemptsDone, retryHandler, fcApiEndpoint);
                    }
                    return null;
                });
            }, (long)Math.max(retryHandler.getRetryDelayMillis(), 500) * (long)Math.pow(2.0, retryAttemptsDone - 1), TimeUnit.MILLISECONDS);
        } else if (throwable != null && retryAttemptsDone == Math.min(retryHandler.getRetryAttempts(), 5)) {
            responseCF.completeExceptionally(throwable);
        } else {
            responseCF.complete(httpResponse);
        }
    }

    public static PersonRequest.PersonRequestBuilder buildPersonRequest() {
        return PersonRequest.builder();
    }

    public static CompanyRequest.CompanyRequestBuilder buildCompanyRequest() {
        return CompanyRequest.builder();
    }

    public static ResolveRequest.ResolveRequestBuilder buildResolveRequest() {
        return ResolveRequest.builder();
    }

    public static TagsRequest.TagsRequestBuilder buildTagsRequest() {
        return TagsRequest.builder();
    }

    public static AudienceRequest.AudienceRequestBuilder buildAudienceRequest() {
        return AudienceRequest.builder();
    }

    @Override
    public void close() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
            this.isShutdown = true;
        }
    }

    public void finalize() {
        this.close();
    }

    public static FullContactBuilder builder() {
        return new FullContactBuilder();
    }

    public static class FullContactBuilder {
        private CredentialsProvider credentialsProvider;
        private Map<String, String> headers;
        private long connectTimeoutMillis;
        private RetryHandler retryHandler;

        public FullContact build() throws FullContactException {
            this.validate();
            return new FullContact(this.credentialsProvider, this.headers, this.connectTimeoutMillis, this.retryHandler);
        }

        private void validate() throws FullContactException {
            if (this.credentialsProvider == null) {
                this.credentialsProvider = new DefaultCredentialProvider();
            }
            if (this.retryHandler == null) {
                this.retryHandler = new DefaultRetryHandler();
            }
        }

        public FullContactBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public FullContactBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public FullContactBuilder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public FullContactBuilder retryHandler(RetryHandler retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        FullContactBuilder() {
        }

        public String toString() {
            return "FullContact.FullContactBuilder(credentialsProvider=" + this.credentialsProvider + ", headers=" + this.headers + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", retryHandler=" + this.retryHandler + ")";
        }
    }
}

