/*
 * Decompiled with CFR 0.152.
 */
package com.getyourguide.openapi.validation.api.model;

import com.getyourguide.openapi.validation.api.log.LogLevel;
import com.getyourguide.openapi.validation.api.model.Direction;
import com.getyourguide.openapi.validation.api.model.RequestMetaData;
import java.util.Optional;

public class OpenApiViolation {
    private final LogLevel level;
    private final Direction direction;
    private final RequestMetaData requestMetaData;
    private final String body;
    private final String rule;
    private final String operationId;
    private final String normalizedPath;
    private final String instance;
    private final String parameter;
    private final String schema;
    private final Integer responseStatus;
    private final String message;
    private final String logMessage;

    public Optional<String> getOperationId() {
        return Optional.ofNullable(this.operationId);
    }

    public Optional<String> getNormalizedPath() {
        return Optional.ofNullable(this.normalizedPath);
    }

    public Optional<String> getInstance() {
        return Optional.ofNullable(this.instance);
    }

    public Optional<String> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    public Optional<String> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    public Optional<Integer> getResponseStatus() {
        return Optional.ofNullable(this.responseStatus);
    }

    OpenApiViolation(LogLevel level, Direction direction, RequestMetaData requestMetaData, String body, String rule, String operationId, String normalizedPath, String instance, String parameter, String schema, Integer responseStatus, String message, String logMessage) {
        this.level = level;
        this.direction = direction;
        this.requestMetaData = requestMetaData;
        this.body = body;
        this.rule = rule;
        this.operationId = operationId;
        this.normalizedPath = normalizedPath;
        this.instance = instance;
        this.parameter = parameter;
        this.schema = schema;
        this.responseStatus = responseStatus;
        this.message = message;
        this.logMessage = logMessage;
    }

    public static OpenApiViolationBuilder builder() {
        return new OpenApiViolationBuilder();
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    public String getBody() {
        return this.body;
    }

    public String getRule() {
        return this.rule;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public static class OpenApiViolationBuilder {
        private LogLevel level;
        private Direction direction;
        private RequestMetaData requestMetaData;
        private String body;
        private String rule;
        private String operationId;
        private String normalizedPath;
        private String instance;
        private String parameter;
        private String schema;
        private Integer responseStatus;
        private String message;
        private String logMessage;

        OpenApiViolationBuilder() {
        }

        public OpenApiViolationBuilder level(LogLevel level) {
            this.level = level;
            return this;
        }

        public OpenApiViolationBuilder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        public OpenApiViolationBuilder requestMetaData(RequestMetaData requestMetaData) {
            this.requestMetaData = requestMetaData;
            return this;
        }

        public OpenApiViolationBuilder body(String body) {
            this.body = body;
            return this;
        }

        public OpenApiViolationBuilder rule(String rule) {
            this.rule = rule;
            return this;
        }

        public OpenApiViolationBuilder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public OpenApiViolationBuilder normalizedPath(String normalizedPath) {
            this.normalizedPath = normalizedPath;
            return this;
        }

        public OpenApiViolationBuilder instance(String instance) {
            this.instance = instance;
            return this;
        }

        public OpenApiViolationBuilder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public OpenApiViolationBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public OpenApiViolationBuilder responseStatus(Integer responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public OpenApiViolationBuilder message(String message) {
            this.message = message;
            return this;
        }

        public OpenApiViolationBuilder logMessage(String logMessage) {
            this.logMessage = logMessage;
            return this;
        }

        public OpenApiViolation build() {
            return new OpenApiViolation(this.level, this.direction, this.requestMetaData, this.body, this.rule, this.operationId, this.normalizedPath, this.instance, this.parameter, this.schema, this.responseStatus, this.message, this.logMessage);
        }

        public String toString() {
            return "OpenApiViolation.OpenApiViolationBuilder(level=" + this.level + ", direction=" + this.direction + ", requestMetaData=" + this.requestMetaData + ", body=" + this.body + ", rule=" + this.rule + ", operationId=" + this.operationId + ", normalizedPath=" + this.normalizedPath + ", instance=" + this.instance + ", parameter=" + this.parameter + ", schema=" + this.schema + ", responseStatus=" + this.responseStatus + ", message=" + this.message + ", logMessage=" + this.logMessage + ")";
        }
    }
}

