/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.featureflag;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.featureflag.FeatureFlag;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="featureFlags")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureFlags
implements Iterable<FeatureFlag> {
    public static final String AGGREGATED_FEATURE_FLAGS_URI = "/gdc/internal/projects/{projectId}/featureFlags";
    private final List<FeatureFlag> featureFlags = new LinkedList<FeatureFlag>();

    @JsonAnySetter
    public void addFlag(String name, boolean enabled) {
        Validate.notNull((Object)name, (String)"name");
        this.featureFlags.add(new FeatureFlag(name, enabled));
    }

    public void removeFlag(String flagName) {
        this.findFlag(flagName).ifPresent(this.featureFlags::remove);
    }

    @JsonAnyGetter
    private Map<String, Boolean> asMap() {
        return this.featureFlags.stream().collect(Collectors.toMap(FeatureFlag::getName, FeatureFlag::isEnabled));
    }

    @Override
    public Iterator<FeatureFlag> iterator() {
        return this.featureFlags.iterator();
    }

    public boolean isEnabled(String flagName) {
        Validate.notEmpty((CharSequence)flagName, (String)"flagName");
        return this.findFlag(flagName).map(FeatureFlag::isEnabled).orElse(false);
    }

    private Optional<FeatureFlag> findFlag(String flagName) {
        return this.featureFlags.stream().filter(f -> flagName.equalsIgnoreCase(f.getName())).findAny();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlags that = (FeatureFlags)o;
        return !(this.featureFlags == null ? that.featureFlags != null : !this.featureFlags.equals(that.featureFlags));
    }

    public int hashCode() {
        return this.featureFlags != null ? this.featureFlags.hashCode() : 0;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

