/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataset;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.PollResult;
import com.gooddata.SimplePollHandler;
import com.gooddata.dataset.Dataset;
import com.gooddata.dataset.DatasetException;
import com.gooddata.dataset.DatasetManifest;
import com.gooddata.dataset.DatasetManifests;
import com.gooddata.dataset.DatasetNotFoundException;
import com.gooddata.dataset.Datasets;
import com.gooddata.dataset.EtlMode;
import com.gooddata.dataset.EtlModeType;
import com.gooddata.dataset.FailPart;
import com.gooddata.dataset.FailStatus;
import com.gooddata.dataset.LookupMode;
import com.gooddata.dataset.MaqlDml;
import com.gooddata.dataset.Pull;
import com.gooddata.dataset.PullTask;
import com.gooddata.dataset.PullTaskStatus;
import com.gooddata.dataset.TaskState;
import com.gooddata.gdc.DataStoreException;
import com.gooddata.gdc.DataStoreService;
import com.gooddata.gdc.TaskStatus;
import com.gooddata.gdc.UriResponse;
import com.gooddata.project.Project;
import com.gooddata.util.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DatasetService
extends AbstractService {
    private static final String MANIFEST_FILE_NAME = "upload_info.json";
    private static final String STATUS_FILE_NAME = "upload_status.json";
    private final DataStoreService dataStoreService;

    public DatasetService(RestTemplate restTemplate, DataStoreService dataStoreService) {
        super(restTemplate);
        this.dataStoreService = Validate.notNull(dataStoreService, "dataStoreService");
    }

    public DatasetManifest getDatasetManifest(Project project, String datasetId) {
        Validate.notNull(project, "project");
        Validate.notEmpty(datasetId, "datasetId");
        try {
            return (DatasetManifest)this.restTemplate.getForObject("/gdc/md/{projectId}/ldm/singleloadinterface/{dataSet}/manifest", DatasetManifest.class, new Object[]{project.getId(), datasetId});
        }
        catch (GoodDataRestException e) {
            if (e.getStatusCode() == 404) {
                throw new DatasetNotFoundException(datasetId, e);
            }
            throw new DatasetException("Unable to get manifest", datasetId, (Throwable)e);
        }
        catch (RestClientException e) {
            throw new DatasetException("Unable to get manifest", datasetId, (Throwable)e);
        }
    }

    public FutureResult<Void> loadDataset(Project project, DatasetManifest manifest, InputStream dataset) {
        Validate.notNull(project, "project");
        Validate.notNull(dataset, "dataset");
        Validate.notNull(manifest, "manifest");
        Path dirPath = Paths.get("/", project.getId() + "_" + RandomStringUtils.randomAlphabetic((int)3), "/");
        try {
            this.dataStoreService.upload(dirPath.resolve(manifest.getFile()).toString(), dataset);
            String manifestJson = this.mapper.writeValueAsString((Object)manifest);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(manifestJson.getBytes(StandardCharsets.UTF_8));
            this.dataStoreService.upload(dirPath.resolve(MANIFEST_FILE_NAME).toString(), (InputStream)inputStream);
            return this.pullLoad(project, dirPath, manifest.getDataSet());
        }
        catch (IOException e) {
            throw new DatasetException("Unable to serialize manifest", manifest.getDataSet(), (Throwable)e);
        }
        catch (GoodDataRestException | DataStoreException | RestClientException e) {
            throw new DatasetException("Unable to load", manifest.getDataSet(), e);
        }
    }

    public FutureResult<Void> loadDataset(Project project, String datasetId, InputStream dataset) {
        Validate.notNull(project, "project");
        Validate.notEmpty(datasetId, "datasetId");
        Validate.notNull(dataset, "dataset");
        return this.loadDataset(project, this.getDatasetManifest(project, datasetId), dataset);
    }

    public FutureResult<Void> loadDatasets(Project project, DatasetManifest ... datasets) {
        return this.loadDatasets(project, Arrays.asList(datasets));
    }

    public FutureResult<Void> loadDatasets(Project project, Collection<DatasetManifest> datasets) {
        Validate.notNull(project, "project");
        this.validateUploadManifests(datasets);
        ArrayList<String> datasetsNames = new ArrayList<String>(datasets.size());
        try {
            Path dirPath = Paths.get("/", project.getId() + "_" + RandomStringUtils.randomAlphabetic((int)3), "/");
            for (DatasetManifest datasetManifest : datasets) {
                datasetsNames.add(datasetManifest.getDataSet());
                this.dataStoreService.upload(dirPath.resolve(datasetManifest.getFile()).toString(), datasetManifest.getSource());
            }
            String manifestJson = this.mapper.writeValueAsString((Object)new DatasetManifests(datasets));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(manifestJson.getBytes(StandardCharsets.UTF_8));
            this.dataStoreService.upload(dirPath.resolve(MANIFEST_FILE_NAME).toString(), (InputStream)inputStream);
            return this.pullLoad(project, dirPath, datasetsNames);
        }
        catch (IOException e) {
            throw new DatasetException("Unable to serialize manifest", datasetsNames, (Throwable)e);
        }
        catch (GoodDataRestException | DataStoreException | RestClientException e) {
            throw new DatasetException("Unable to load", datasetsNames, e);
        }
    }

    private void validateUploadManifests(Collection<DatasetManifest> datasets) {
        Validate.notEmpty(datasets, "datasets");
        for (DatasetManifest datasetManifest : datasets) {
            if (datasetManifest.getSource() == null) {
                throw new IllegalArgumentException(String.format("Source for dataset '%s' is null", datasetManifest.getDataSet()));
            }
            if (datasetManifest.getFile() == null) {
                throw new IllegalArgumentException(String.format("File for dataset '%s' is null", datasetManifest.getDataSet()));
            }
            if (!StringUtils.isEmpty((Object)datasetManifest.getDataSet())) continue;
            throw new IllegalArgumentException("Dataset name is empty.");
        }
    }

    private FutureResult<Void> pullLoad(Project project, Path dirPath, String dataset) {
        return this.pullLoad(project, dirPath, Arrays.asList(dataset));
    }

    private FutureResult<Void> pullLoad(Project project, final Path dirPath, final Collection<String> datasets) {
        PullTask pullTask = (PullTask)this.restTemplate.postForObject("/gdc/md/{projectId}/etl/pull", (Object)new Pull(dirPath.toString()), PullTask.class, new Object[]{project.getId()});
        return new PollResult<Void>(this, new SimplePollHandler<Void>(pullTask.getUri(), Void.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                PullTaskStatus status = (PullTaskStatus)DatasetService.this.extractData(response, PullTaskStatus.class);
                boolean finished = status.isFinished();
                if (finished && !status.isSuccess()) {
                    String message = DatasetService.this.getErrorMessage(status, dirPath);
                    throw new DatasetException(message, datasets);
                }
                return finished;
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new DatasetException("Unable to load", datasets, (Throwable)e);
            }

            @Override
            protected void onFinish() {
                try {
                    DatasetService.this.dataStoreService.delete(dirPath.toString());
                }
                catch (DataStoreException dataStoreException) {
                    // empty catch block
                }
            }
        });
    }

    private String getErrorMessage(PullTaskStatus status, Path dirPath) {
        String message = "status: " + status.getStatus();
        try {
            FailStatus failStatus = this.download(dirPath.resolve(STATUS_FILE_NAME), FailStatus.class);
            if (failStatus != null) {
                List<FailPart> errorParts = failStatus.getErrorParts();
                if (!errorParts.isEmpty()) {
                    ArrayList<String> errors = new ArrayList<String>();
                    for (FailPart part : errorParts) {
                        if (part.getLogName() == null) continue;
                        try {
                            String[] msg = this.download(dirPath.resolve(part.getLogName()), String[].class);
                            errors.addAll(Arrays.asList(msg));
                        }
                        catch (DataStoreException | IOException e) {
                            if (part.getError() == null) continue;
                            errors.add(part.getError().getFormattedMessage());
                        }
                    }
                    message = ((Object)errors).toString();
                } else if (failStatus.getError() != null) {
                    message = failStatus.getError().getFormattedMessage();
                }
            }
        }
        catch (DataStoreException | IOException ignored) {
            // empty catch block
        }
        return message;
    }

    private <T> T download(Path path, Class<T> type) throws IOException {
        try (InputStream input = this.dataStoreService.download(path.toString());){
            Object object = this.mapper.readValue(input, type);
            return (T)object;
        }
    }

    public Collection<Dataset> listDatasets(Project project) {
        Validate.notNull(project, "project");
        try {
            Datasets result = (Datasets)this.restTemplate.getForObject("/gdc/md/{project}/ldm/singleloadinterface", Datasets.class, new Object[]{project.getId()});
            if (result == null) {
                throw new GoodDataException("Empty response from API call");
            }
            if (result.getLinks() == null) {
                return Collections.emptyList();
            }
            return result.getLinks();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list datasets for project " + project.getId(), e);
        }
    }

    public FutureResult<Void> optimizeSliHash(final Project project) {
        Validate.notNull(project, "project");
        UriResponse uriResponse = (UriResponse)this.restTemplate.postForObject("/gdc/md/{project}/etl/mode", (Object)new EtlMode(EtlModeType.SLI, LookupMode.RECREATE), UriResponse.class, new Object[]{project.getId()});
        return new PollResult<Void>(this, new AbstractPollHandler<TaskStatus, Void>(uriResponse.getUri(), TaskStatus.class, Void.class){

            @Override
            public void handlePollResult(TaskStatus pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new GoodDataException("Unable to optimize SLI hash for project " + project.getId());
                }
                this.setResult(null);
            }

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                if (!super.isFinished(response)) {
                    return false;
                }
                TaskStatus maqlDdlTaskStatus = (TaskStatus)DatasetService.this.extractData(response, TaskStatus.class);
                if (maqlDdlTaskStatus.isSuccess()) {
                    return true;
                }
                throw new GoodDataException("Unable to optimize SLI hash: " + maqlDdlTaskStatus.getMessages());
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to optimize SLI hash: " + this.getPollingUri(), e);
            }
        });
    }

    public FutureResult<Void> updateProjectData(Project project, String maqlDml) {
        Validate.notNull(project, "project");
        UriResponse uriResponse = (UriResponse)this.restTemplate.postForObject("/gdc/md/{project}/dml/manage", (Object)new MaqlDml(maqlDml), UriResponse.class, new Object[]{project.getId()});
        final String errorMessage = String.format("Unable to update data for project '%s'", project.getId());
        return new PollResult<Void>(this, new AbstractPollHandler<TaskState, Void>(uriResponse.getUri(), TaskState.class, Void.class){

            @Override
            public void handlePollResult(TaskState pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new GoodDataException(errorMessage);
                }
                this.setResult(null);
            }

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                TaskState taskState = (TaskState)DatasetService.this.extractData(response, TaskState.class);
                if (taskState.isSuccess()) {
                    return true;
                }
                if (!taskState.isFinished()) {
                    return false;
                }
                throw new GoodDataException(errorMessage + ": " + taskState.getMessage());
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException(errorMessage + ": " + this.getPollingUri(), e);
            }
        });
    }
}

