/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.project;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.PollResult;
import com.gooddata.SimplePollHandler;
import com.gooddata.account.AccountService;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageableList;
import com.gooddata.gdc.AsyncTask;
import com.gooddata.gdc.FeatureFlag;
import com.gooddata.gdc.FeatureFlags;
import com.gooddata.gdc.UriResponse;
import com.gooddata.project.Project;
import com.gooddata.project.ProjectFeatureFlag;
import com.gooddata.project.ProjectFeatureFlags;
import com.gooddata.project.ProjectNotFoundException;
import com.gooddata.project.ProjectTemplate;
import com.gooddata.project.ProjectTemplates;
import com.gooddata.project.ProjectValidationResults;
import com.gooddata.project.ProjectValidationType;
import com.gooddata.project.ProjectValidations;
import com.gooddata.project.Projects;
import com.gooddata.project.Role;
import com.gooddata.project.RoleNotFoundException;
import com.gooddata.project.Roles;
import com.gooddata.project.User;
import com.gooddata.project.Users;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ProjectService
extends AbstractService {
    private final AccountService accountService;

    public ProjectService(RestTemplate restTemplate, AccountService accountService) {
        super(restTemplate);
        this.accountService = Validate.notNull(accountService, "accountService");
    }

    public Collection<Project> getProjects() {
        try {
            String id = this.accountService.getCurrent().getId();
            Projects projects = (Projects)this.restTemplate.getForObject("/gdc/account/profile/{id}/projects", Projects.class, new Object[]{id});
            return projects.getProjects();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get projects", e);
        }
    }

    public FutureResult<Project> createProject(Project project) {
        UriResponse uri;
        Validate.notNull(project, "project");
        try {
            uri = (UriResponse)this.restTemplate.postForObject("/gdc/projects", (Object)project, UriResponse.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create project", e);
        }
        if (uri == null) {
            throw new GoodDataException("Empty response when project POSTed to API");
        }
        return new PollResult<Project>(this, new SimplePollHandler<Project>(uri.getUri(), Project.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                Project project = (Project)ProjectService.this.extractData(response, Project.class);
                return !project.isPreparing();
            }

            @Override
            protected void onFinish() {
                if (!((Project)this.getResult()).isEnabled()) {
                    throw new GoodDataException("Created project " + uri + " is not enabled");
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Creating project " + uri + " failed", e);
            }
        });
    }

    public Project getProjectByUri(String uri) {
        Validate.notEmpty(uri, "uri");
        try {
            return (Project)this.restTemplate.getForObject(uri, Project.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ProjectNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get project " + uri, e);
        }
    }

    public Project getProjectById(String id) {
        Validate.notEmpty(id, "id");
        return this.getProjectByUri(Project.TEMPLATE.expand(new Object[]{id}).toString());
    }

    public void removeProject(Project project) {
        Validate.notNull(project, "project");
        try {
            this.restTemplate.delete(project.getUri(), new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to delete project " + project.getId(), e);
        }
    }

    public Collection<ProjectTemplate> getProjectTemplates(Project project) {
        Validate.notNull(project, "project");
        try {
            ProjectTemplates templates = (ProjectTemplates)this.restTemplate.getForObject("/gdc/md/{projectId}/templates", ProjectTemplates.class, new Object[]{project.getId()});
            return templates != null && templates.getTemplatesInfo() != null ? templates.getTemplatesInfo() : Collections.emptyList();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get project templates", e);
        }
    }

    public Set<ProjectValidationType> getAvailableProjectValidationTypes(Project project) {
        Validate.notNull(project, "project");
        try {
            return ((ProjectValidations)this.restTemplate.getForObject("/gdc/md/{projectId}/validate", ProjectValidations.class, new Object[]{project.getId()})).getValidations();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to get project available validation types", e);
        }
    }

    public FutureResult<ProjectValidationResults> validateProject(Project project) {
        return this.validateProject(project, this.getAvailableProjectValidationTypes(project));
    }

    public FutureResult<ProjectValidationResults> validateProject(Project project, ProjectValidationType ... validations) {
        return this.validateProject(project, new HashSet<ProjectValidationType>(Arrays.asList(validations)));
    }

    public FutureResult<ProjectValidationResults> validateProject(Project project, Set<ProjectValidationType> validations) {
        AsyncTask task;
        Validate.notNull(project, "project");
        try {
            task = (AsyncTask)this.restTemplate.postForObject("/gdc/md/{projectId}/validate", (Object)new ProjectValidations(validations), AsyncTask.class, new Object[]{project.getId()});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to to start project validation", e);
        }
        return new PollResult<ProjectValidationResults>(this, new AbstractPollHandler<Void, ProjectValidationResults>(task.getUri(), Void.class, ProjectValidationResults.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                boolean finished;
                URI location = response.getHeaders().getLocation();
                if (location != null) {
                    this.setPollingUri(location.toString());
                }
                if (finished = super.isFinished(response)) {
                    try {
                        ProjectValidationResults result = (ProjectValidationResults)ProjectService.this.restTemplate.getForObject(this.getPollingUri(), this.getResultClass(), new Object[0]);
                        this.setResult(result);
                    }
                    catch (GoodDataException | RestClientException e) {
                        throw new GoodDataException("Unable to obtain validation results from " + this.getPollingUri());
                    }
                }
                return finished;
            }

            @Override
            public void handlePollResult(Void pollResult) {
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Project validation failed: " + this.getPollingUri(), e);
            }
        });
    }

    public List<User> listUsers(Project project) {
        Validate.notNull(project, "project");
        return this.listUsers(ProjectService.getUsersUri(project));
    }

    public List<User> listUsers(Project project, Page page) {
        Validate.notNull(project, "project");
        Validate.notNull(page, "page");
        return this.listUsers(page.getPageUri(UriComponentsBuilder.fromUri((URI)ProjectService.getUsersUri(project))));
    }

    private PageableList<User> listUsers(URI uri) {
        try {
            Users users = (Users)this.restTemplate.getForObject(uri, Users.class);
            if (users == null) {
                return new PageableList<User>();
            }
            return users;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list users", e);
        }
    }

    private static URI getUsersUri(Project project) {
        return Users.TEMPLATE.expand(new Object[]{project.getId()});
    }

    public Set<Role> getRoles(Project project) {
        Validate.notNull(project, "project");
        Roles roles = (Roles)this.restTemplate.getForObject("/gdc/projects/{projectId}/roles", Roles.class, new Object[]{project.getId()});
        HashSet<Role> result = new HashSet<Role>();
        for (String roleUri : roles.getRoles()) {
            Role role = (Role)this.restTemplate.getForObject(roleUri, Role.class, new Object[0]);
            role.setUri(roleUri);
            result.add(role);
        }
        return result;
    }

    public Role getRoleByUri(String uri) {
        Validate.notEmpty(uri, "uri");
        try {
            return (Role)this.restTemplate.getForObject(uri, Role.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new RoleNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get role " + uri, e);
        }
    }

    public List<FeatureFlag> listAggregatedFeatureFlags(Project project) {
        Validate.notNull(project, "project");
        try {
            FeatureFlags featureFlags = (FeatureFlags)this.restTemplate.getForObject(FeatureFlags.AGGREGATED_FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}), FeatureFlags.class);
            if (featureFlags == null) {
                throw new GoodDataException("empty response from API call");
            }
            return featureFlags.getFeatureFlags();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list aggregated feature flags for project ID=" + project.getId(), e);
        }
    }

    public List<ProjectFeatureFlag> listFeatureFlags(Project project) {
        Validate.notNull(project, "project");
        try {
            ProjectFeatureFlags projectFeatureFlags = (ProjectFeatureFlags)this.restTemplate.getForObject(ProjectFeatureFlags.FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}), ProjectFeatureFlags.class);
            if (projectFeatureFlags == null) {
                throw new GoodDataException("empty response from API call");
            }
            return projectFeatureFlags.getItems();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list project feature flags for project ID=" + project.getId(), e);
        }
    }

    public ProjectFeatureFlag createFeatureFlag(Project project, ProjectFeatureFlag featureFlag) {
        Validate.notNull(project, "project");
        Validate.notNull(featureFlag, "featureFlag");
        String featureFlagsUri = ProjectFeatureFlags.FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}).toString();
        try {
            URI featureFlagUri = this.restTemplate.postForLocation(featureFlagsUri, (Object)featureFlag, new Object[0]);
            Validate.notNull(featureFlagsUri, "URI of new featureFlag");
            return this.getFeatureFlag(featureFlagUri.toString());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create feature flag: " + featureFlag, e);
        }
    }

    public ProjectFeatureFlag getFeatureFlag(Project project, String featureFlagName) {
        Validate.notNull(project, "project");
        Validate.notEmpty(featureFlagName, "featureFlagName");
        return (ProjectFeatureFlag)this.restTemplate.getForObject(this.getFeatureFlagUri(project, featureFlagName), ProjectFeatureFlag.class, new Object[0]);
    }

    public ProjectFeatureFlag updateFeatureFlag(ProjectFeatureFlag featureFlag) {
        Validate.notNull(featureFlag, "featureFlag");
        Validate.notEmpty(featureFlag.getUri(), "featureFlag");
        try {
            this.restTemplate.put(featureFlag.getUri(), (Object)featureFlag, new Object[0]);
            return this.getFeatureFlag(featureFlag.getUri());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create feature flag: " + featureFlag, e);
        }
    }

    public void deleteFeatureFlag(ProjectFeatureFlag featureFlag) {
        Validate.notNull(featureFlag, "featureFlag");
        Validate.notEmpty(featureFlag.getUri(), "featureFlag URI");
        try {
            this.restTemplate.delete(featureFlag.getUri(), new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to delete feature flag=" + featureFlag, e);
        }
    }

    private ProjectFeatureFlag getFeatureFlag(String featureFlagUri) {
        return (ProjectFeatureFlag)this.restTemplate.getForObject(featureFlagUri, ProjectFeatureFlag.class, new Object[0]);
    }

    private String getFeatureFlagUri(Project project, String featureFlagName) {
        return ProjectFeatureFlag.FEATURE_FLAG_TEMPLATE.expand(new Object[]{project.getId(), featureFlagName}).toString();
    }
}

