/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.gdc.UriResponse;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.util.BooleanDeserializer;

@JsonTypeName(value="dataLoadingColumn")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataLoadingColumn
extends AbstractObj
implements Queryable {
    private static final String INT = "INT";
    private static final String VARCHAR = "VARCHAR";
    private final Content content;

    @JsonCreator
    private DataLoadingColumn(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    public UriResponse getColumnUri() {
        return this.content.getColumnUri();
    }

    public String getName() {
        return this.content.getColumnName();
    }

    public String getType() {
        return this.content.getColumnType();
    }

    public boolean hasTypeVarchar() {
        return VARCHAR.equals(this.getType());
    }

    public boolean hasTypeInt() {
        return INT.equals(this.getType());
    }

    public Integer getLength() {
        return this.content.getColumnLength();
    }

    public Integer getPrecision() {
        return this.content.getColumnPrecision();
    }

    public boolean isUnique() {
        return this.content.isColumnUnique();
    }

    public boolean isNullable() {
        return this.content.isColumnNull();
    }

    public String getSynchronizeType() {
        return this.content.getColumnSynchronize() != null ? this.content.getColumnSynchronize().getType() : null;
    }

    public Integer getSynchronizeLength() {
        return this.content.getColumnSynchronize() != null ? this.content.getColumnSynchronize().getLength() : null;
    }

    public Integer getSynchronizePrecision() {
        return this.content.getColumnSynchronize() != null ? this.content.getColumnSynchronize().getPrecision() : null;
    }

    private static class ColumnSynchronize {
        private final String type;
        private final Integer length;
        private final Integer precision;

        @JsonCreator
        private ColumnSynchronize(@JsonProperty(value="columnType") String type, @JsonProperty(value="columnLength") Integer length, @JsonProperty(value="columnPrecision") Integer precision) {
            this.type = type;
            this.length = length;
            this.precision = precision;
        }

        public String getType() {
            return this.type;
        }

        public Integer getLength() {
            return this.length;
        }

        public Integer getPrecision() {
            return this.precision;
        }
    }

    private static class Content {
        private final UriResponse columnUri;
        private final String columnName;
        private final String columnType;
        private final Integer columnLength;
        private final Integer columnPrecision;
        private final boolean columnUnique;
        private final boolean columnNull;
        private final ColumnSynchronize columnSynchronize;

        private Content(@JsonProperty(value="column") UriResponse columnUri, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="type") String columnType, @JsonProperty(value="length") Integer columnLength, @JsonProperty(value="precision") Integer columnPrecision, @JsonProperty(value="columnUnique") @JsonDeserialize(using=BooleanDeserializer.class) boolean columnUnique, @JsonProperty(value="columnNull") @JsonDeserialize(using=BooleanDeserializer.class) boolean columnNull, @JsonProperty(value="columnSynchronize") ColumnSynchronize columnSynchronize) {
            this.columnUri = columnUri;
            this.columnName = columnName;
            this.columnType = columnType;
            this.columnLength = columnLength;
            this.columnPrecision = columnPrecision;
            this.columnUnique = columnUnique;
            this.columnNull = columnNull;
            this.columnSynchronize = columnSynchronize;
        }

        public UriResponse getColumnUri() {
            return this.columnUri;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public Integer getColumnLength() {
            return this.columnLength;
        }

        public Integer getColumnPrecision() {
            return this.columnPrecision;
        }

        public boolean isColumnUnique() {
            return this.columnUnique;
        }

        public boolean isColumnNull() {
            return this.columnNull;
        }

        public ColumnSynchronize getColumnSynchronize() {
            return this.columnSynchronize;
        }
    }
}

