/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.GoodDataEndpoint;
import com.gooddata.UriPrefixer;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;

class UriPrefixingClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory wrapped;
    private final UriPrefixer prefixer;

    UriPrefixingClientHttpRequestFactory(ClientHttpRequestFactory factory, URI uriPrefix) {
        this(factory, new UriPrefixer(uriPrefix));
    }

    UriPrefixingClientHttpRequestFactory(ClientHttpRequestFactory factory, GoodDataEndpoint endpoint) {
        this(factory, new UriPrefixer(Validate.notNull(endpoint, "prefixer").toUri()));
    }

    private UriPrefixingClientHttpRequestFactory(ClientHttpRequestFactory factory, UriPrefixer prefixer) {
        this.wrapped = Validate.notNull(factory, "factory");
        this.prefixer = Validate.notNull(prefixer, "prefixer");
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        URI merged = this.prefixer.mergeUris(uri);
        return this.wrapped.createRequest(merged, httpMethod);
    }
}

