/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.visualization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gooddata.executeafm.Execution;
import com.gooddata.executeafm.afm.Afm;
import com.gooddata.executeafm.afm.AttributeItem;
import com.gooddata.executeafm.afm.CompatibilityFilter;
import com.gooddata.executeafm.afm.DateFilter;
import com.gooddata.executeafm.afm.FilterItem;
import com.gooddata.executeafm.afm.MeasureItem;
import com.gooddata.executeafm.afm.NegativeAttributeFilter;
import com.gooddata.executeafm.afm.PositiveAttributeFilter;
import com.gooddata.executeafm.afm.SimpleMeasureDefinition;
import com.gooddata.executeafm.resultspec.Dimension;
import com.gooddata.executeafm.resultspec.ResultSpec;
import com.gooddata.executeafm.resultspec.SortItem;
import com.gooddata.md.visualization.CollectionType;
import com.gooddata.md.visualization.Measure;
import com.gooddata.md.visualization.VisualizationAttribute;
import com.gooddata.md.visualization.VisualizationClass;
import com.gooddata.md.visualization.VisualizationObject;
import com.gooddata.md.visualization.VisualizationType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public abstract class VisualizationConverter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static Execution convertToExecution(VisualizationObject visualizationObject, Function<String, VisualizationClass> visualizationClassGetter) {
        ResultSpec resultSpec = VisualizationConverter.convertToResultSpec(visualizationObject, visualizationClassGetter);
        Afm afm = VisualizationConverter.convertToAfm(visualizationObject);
        return new Execution(afm, resultSpec);
    }

    public static Afm convertToAfm(VisualizationObject visualizationObject) {
        List<AttributeItem> attributes = VisualizationConverter.convertAttributes(visualizationObject.getAttributes());
        List<CompatibilityFilter> filters = VisualizationConverter.convertFilters(visualizationObject.getFilters());
        List<MeasureItem> measures = VisualizationConverter.convertMeasures(visualizationObject.getMeasures());
        return new Afm(attributes, filters, measures, null);
    }

    public static ResultSpec convertToResultSpec(VisualizationObject visualizationObject, Function<String, VisualizationClass> visualizationClassGetter) {
        VisualizationClass visualizationClass = (VisualizationClass)((Function)Validate.notNull(visualizationClassGetter)).apply(((VisualizationObject)Validate.notNull((Object)visualizationObject)).getVisualizationClassUri());
        List<SortItem> sorts = VisualizationConverter.getSorting(visualizationObject);
        List<Dimension> dimensions = VisualizationConverter.getDimensions(visualizationObject, visualizationClass.getVisualizationType());
        return new ResultSpec(dimensions, sorts);
    }

    static List<SortItem> getSorting(VisualizationObject visualizationObject) {
        try {
            List<SortItem> sorts = VisualizationConverter.parseSorting(visualizationObject.getProperties());
            if (sorts != null) {
                return sorts;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static List<SortItem> parseSorting(String properties) throws Exception {
        JsonNode jsonProperties = VisualizationConverter.parseProperties(properties);
        JsonNode nodeSortItems = jsonProperties.get("sortItems");
        TypeReference<List<SortItem>> mapType = new TypeReference<List<SortItem>>(){};
        return (List)MAPPER.convertValue((Object)nodeSortItems, (TypeReference)mapType);
    }

    private static List<Dimension> getDimensions(VisualizationObject visualizationObject, VisualizationType visualizationType) {
        switch (visualizationType) {
            case COLUMN: 
            case BAR: {
                return VisualizationConverter.getDimensionsForStacked(visualizationObject, CollectionType.STACK, CollectionType.VIEW);
            }
            case LINE: {
                return VisualizationConverter.getDimensionsForStacked(visualizationObject, CollectionType.SEGMENT, CollectionType.TREND);
            }
            case PIE: {
                return VisualizationConverter.getDimensionsForPie(visualizationObject);
            }
        }
        return VisualizationConverter.getDimensionsForTable(visualizationObject);
    }

    private static List<Dimension> getDimensionsForPie(VisualizationObject visualizationObject) {
        VisualizationAttribute attribute = visualizationObject.getView();
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (visualizationObject.hasMeasures()) {
            dimensions.add(new Dimension("measureGroup"));
        }
        if (attribute != null) {
            dimensions.add(new Dimension(attribute.getLocalIdentifier()));
        }
        return dimensions;
    }

    private static List<Dimension> getDimensionsForStacked(VisualizationObject visualizationObject, CollectionType stackBy, CollectionType viewBy) {
        VisualizationAttribute stack = visualizationObject.getAttributeFromCollection(stackBy);
        VisualizationAttribute view = visualizationObject.getAttributeFromCollection(viewBy);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (stack != null) {
            dimensions.add(new Dimension(stack.getLocalIdentifier()));
            ArrayList<String> dimensionItems = new ArrayList<String>();
            if (view != null) {
                dimensionItems.add(view.getLocalIdentifier());
            }
            if (visualizationObject.hasMeasures()) {
                dimensionItems.add("measureGroup");
            }
            if (!dimensionItems.isEmpty()) {
                dimensions.add(new Dimension(dimensionItems));
            }
        } else {
            if (visualizationObject.hasMeasures()) {
                dimensions.add(new Dimension("measureGroup"));
            }
            if (view != null) {
                dimensions.add(new Dimension(view.getLocalIdentifier()));
            }
        }
        return dimensions;
    }

    private static List<Dimension> getDimensionsForTable(VisualizationObject visualizationObject) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        List<VisualizationAttribute> attributes = visualizationObject.getAttributes();
        if (!attributes.isEmpty()) {
            dimensions.add(new Dimension(attributes.stream().map(AttributeItem::getLocalIdentifier).collect(Collectors.toList())));
        } else {
            dimensions.add(new Dimension(new ArrayList<String>()));
        }
        if (visualizationObject.hasMeasures()) {
            dimensions.add(new Dimension("measureGroup"));
        }
        return dimensions;
    }

    private static JsonNode parseProperties(String properties) throws Exception {
        return (JsonNode)MAPPER.readValue(properties, JsonNode.class);
    }

    private static List<AttributeItem> convertAttributes(List<VisualizationAttribute> attributes) {
        return attributes.stream().map(AttributeItem.class::cast).collect(Collectors.toList());
    }

    private static List<CompatibilityFilter> convertFilters(List<FilterItem> filters) {
        if (filters == null) {
            return new ArrayList<CompatibilityFilter>();
        }
        List<FilterItem> validFilters = VisualizationConverter.removeIrrelevantFilters(filters);
        return VisualizationConverter.getCompatibilityFilters(validFilters);
    }

    private static List<MeasureItem> convertMeasures(List<Measure> measures) {
        return measures.stream().map(VisualizationConverter::removeFormat).map(VisualizationConverter::getAfmMeasure).map(VisualizationConverter::convertMeasureFilters).collect(Collectors.toList());
    }

    private static Measure removeFormat(Measure measure) {
        if (measure.hasComputeRatio()) {
            measure.setFormat("");
        }
        return measure;
    }

    private static MeasureItem getAfmMeasure(Measure measure) {
        String alias;
        String usedTitle = alias = measure.getAlias();
        if ((alias == null || alias.isEmpty()) && measure.getTitle() != null) {
            usedTitle = measure.getTitle();
        }
        return new MeasureItem(measure.getDefinition(), measure.getLocalIdentifier(), usedTitle, measure.getFormat());
    }

    private static MeasureItem convertMeasureFilters(MeasureItem measure) {
        if (measure.getDefinition() instanceof SimpleMeasureDefinition) {
            List<FilterItem> filters = ((SimpleMeasureDefinition)measure.getDefinition()).getFilters();
            List<FilterItem> validFilters = filters == null ? new ArrayList<FilterItem>() : VisualizationConverter.removeIrrelevantFilters(filters);
            ((SimpleMeasureDefinition)measure.getDefinition()).setFilters(validFilters);
        }
        return measure;
    }

    private static List<CompatibilityFilter> getCompatibilityFilters(List<FilterItem> filters) {
        return filters;
    }

    private static List<FilterItem> removeIrrelevantFilters(List<FilterItem> filters) {
        return filters.stream().filter(f -> {
            if (f instanceof DateFilter) {
                return !((DateFilter)f).isAllTimeSelected();
            }
            if (f instanceof NegativeAttributeFilter) {
                return !((NegativeAttributeFilter)f).isAllSelected();
            }
            return f instanceof PositiveAttributeFilter;
        }).collect(Collectors.toList());
    }
}

