/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.PollHandler;
import com.gooddata.util.Validate;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public abstract class AbstractPollHandlerBase<P, R>
implements PollHandler<P, R> {
    protected final Class<P> pollClass;
    protected final Class<R> resultClass;
    private boolean done = false;
    private R result;

    protected AbstractPollHandlerBase(Class<P> pollClass, Class<R> resultClass) {
        this.pollClass = (Class)Validate.notNull(pollClass, (String)"pollClass");
        this.resultClass = (Class)Validate.notNull(resultClass, (String)"resultClass");
    }

    @Override
    public final Class<R> getResultClass() {
        return this.resultClass;
    }

    @Override
    public final Class<P> getPollClass() {
        return this.pollClass;
    }

    protected PollHandler<P, R> setResult(R result) {
        this.result = result;
        this.done = true;
        this.onFinish();
        return this;
    }

    @Override
    public final boolean isDone() {
        return this.done;
    }

    @Override
    public final R getResult() {
        return this.result;
    }

    @Override
    public boolean isFinished(ClientHttpResponse response) throws IOException {
        return HttpStatus.OK.equals((Object)response.getStatusCode());
    }

    protected void onFinish() {
    }
}

