/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.gooddata.util.Validate;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;

public enum Total {
    SUM,
    AVG,
    MAX,
    MIN,
    NAT,
    MED;


    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static Total of(String total) {
        Validate.notNull((Object)total, (String)"total");
        try {
            return Total.valueOf(total.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("Unknown value for Grid's total: \"%s\", supported values are: [%s]", total, StringUtils.arrayToCommaDelimitedString((Object[])Total.values())), e);
        }
    }

    public static List<Total> orderedValues() {
        return Arrays.asList(SUM, MAX, MIN, AVG, MED, NAT);
    }
}

