/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.Authentication;
import com.gooddata.DeprecationWarningRequestInterceptor;
import com.gooddata.GoodDataEndpoint;
import com.gooddata.GoodDataSettings;
import com.gooddata.HeaderSettingRequestInterceptor;
import com.gooddata.UriPrefixingClientHttpRequestFactory;
import com.gooddata.account.AccountService;
import com.gooddata.auditevent.AuditEventService;
import com.gooddata.authentication.LoginPasswordAuthentication;
import com.gooddata.connector.ConnectorService;
import com.gooddata.dataload.OutputStageService;
import com.gooddata.dataload.processes.ProcessService;
import com.gooddata.dataset.DatasetService;
import com.gooddata.executeafm.ExecuteAfmService;
import com.gooddata.export.ExportService;
import com.gooddata.featureflag.FeatureFlagService;
import com.gooddata.gdc.DataStoreService;
import com.gooddata.gdc.GdcService;
import com.gooddata.lcm.LcmService;
import com.gooddata.md.MetadataService;
import com.gooddata.md.maintenance.ExportImportService;
import com.gooddata.model.ModelService;
import com.gooddata.notification.NotificationService;
import com.gooddata.project.ProjectService;
import com.gooddata.projecttemplate.ProjectTemplateService;
import com.gooddata.report.ReportService;
import com.gooddata.retry.RetrySettings;
import com.gooddata.retry.RetryableRestTemplate;
import com.gooddata.util.ResponseErrorHandler;
import com.gooddata.util.Validate;
import com.gooddata.warehouse.WarehouseService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.VersionInfo;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestTemplate;

public class GoodData {
    @Deprecated
    public static final String GDC_REQUEST_ID_HEADER = "X-GDC-REQUEST";
    protected static final String PROTOCOL = "https";
    protected static final int PORT = 443;
    protected static final String HOSTNAME = "secure.gooddata.com";
    private static final String UNKNOWN_VERSION = "UNKNOWN";
    private final RestTemplate restTemplate;
    private final HttpClient httpClient;
    private final AccountService accountService;
    private final ProjectService projectService;
    private final MetadataService metadataService;
    private final ModelService modelService;
    private final GdcService gdcService;
    private final DataStoreService dataStoreService;
    private final DatasetService datasetService;
    private final ReportService reportService;
    private final ConnectorService connectorService;
    private final ProcessService processService;
    private final WarehouseService warehouseService;
    private final NotificationService notificationService;
    private final ExportImportService exportImportService;
    private final FeatureFlagService featureFlagService;
    private final OutputStageService outputStageService;
    private final ProjectTemplateService projectTemplateService;
    private final ExportService exportService;
    private final AuditEventService auditEventService;
    private final ExecuteAfmService executeAfmService;
    private final LcmService lcmService;

    public GoodData(String login, String password) {
        this(HOSTNAME, login, password, new GoodDataSettings());
    }

    public GoodData(String login, String password, GoodDataSettings settings) {
        this(HOSTNAME, login, password, settings);
    }

    public GoodData(String hostname, String login, String password) {
        this(hostname, login, password, 443, PROTOCOL, new GoodDataSettings());
    }

    public GoodData(String hostname, String login, String password, GoodDataSettings settings) {
        this(hostname, login, password, 443, PROTOCOL, settings);
    }

    public GoodData(String hostname, String login, String password, int port) {
        this(hostname, login, password, port, PROTOCOL, new GoodDataSettings());
    }

    public GoodData(String hostname, String login, String password, int port, GoodDataSettings settings) {
        this(hostname, login, password, port, PROTOCOL, settings);
    }

    protected GoodData(String hostname, String login, String password, int port, String protocol, GoodDataSettings settings) {
        this(new GoodDataEndpoint(hostname, port, protocol), new LoginPasswordAuthentication(login, password), settings);
    }

    protected GoodData(GoodDataEndpoint endpoint, Authentication authentication) {
        this(endpoint, authentication, new GoodDataSettings());
    }

    protected GoodData(GoodDataEndpoint endpoint, Authentication authentication, GoodDataSettings settings) {
        this.httpClient = authentication.createHttpClient(endpoint, this.createHttpClientBuilder(settings));
        this.restTemplate = GoodData.createRestTemplate(endpoint, this.httpClient, settings.getRetrySettings());
        this.accountService = new AccountService(this.getRestTemplate(), settings);
        this.projectService = new ProjectService(this.getRestTemplate(), this.accountService, settings);
        this.metadataService = new MetadataService(this.getRestTemplate(), settings);
        this.modelService = new ModelService(this.getRestTemplate(), settings);
        this.gdcService = new GdcService(this.getRestTemplate(), settings);
        this.dataStoreService = new DataStoreService(this.getHttpClient(), this.getRestTemplate(), this.gdcService, endpoint.toUri());
        this.datasetService = new DatasetService(this.getRestTemplate(), this.dataStoreService, settings);
        this.exportService = new ExportService(this.getRestTemplate(), endpoint, settings);
        this.reportService = new ReportService(this.exportService, this.getRestTemplate(), settings);
        this.processService = new ProcessService(this.getRestTemplate(), this.accountService, this.dataStoreService, settings);
        this.warehouseService = new WarehouseService(this.getRestTemplate(), settings);
        this.connectorService = new ConnectorService(this.getRestTemplate(), this.projectService, settings);
        this.notificationService = new NotificationService(this.getRestTemplate(), settings);
        this.exportImportService = new ExportImportService(this.getRestTemplate(), settings);
        this.featureFlagService = new FeatureFlagService(this.getRestTemplate(), settings);
        this.outputStageService = new OutputStageService(this.getRestTemplate(), settings);
        this.projectTemplateService = new ProjectTemplateService(this.getRestTemplate(), settings);
        this.auditEventService = new AuditEventService(this.getRestTemplate(), this.accountService, settings);
        this.executeAfmService = new ExecuteAfmService(this.getRestTemplate(), settings);
        this.lcmService = new LcmService(this.getRestTemplate(), settings);
    }

    static RestTemplate createRestTemplate(GoodDataEndpoint endpoint, HttpClient httpClient, RetrySettings retrySettings) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)httpClient, (String)"httpClient");
        UriPrefixingClientHttpRequestFactory factory = new UriPrefixingClientHttpRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(httpClient), endpoint.toUri());
        HashMap<String, String> presetHeaders = new HashMap<String, String>(2);
        presetHeaders.put("Accept", "application/json");
        presetHeaders.put("X-GDC-Version", GoodData.readApiVersion());
        RestTemplate restTemplate = retrySettings == null ? new RestTemplate((ClientHttpRequestFactory)factory) : RetryableRestTemplate.create(retrySettings, (ClientHttpRequestFactory)factory);
        restTemplate.setInterceptors(Arrays.asList(new HeaderSettingRequestInterceptor(presetHeaders), new DeprecationWarningRequestInterceptor()));
        restTemplate.setErrorHandler((org.springframework.web.client.ResponseErrorHandler)new ResponseErrorHandler(restTemplate.getMessageConverters()));
        return restTemplate;
    }

    private HttpClientBuilder createHttpClientBuilder(GoodDataSettings settings) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(settings.getMaxConnections());
        connectionManager.setMaxTotal(settings.getMaxConnections());
        SocketConfig.Builder socketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT);
        socketConfig.setSoTimeout(settings.getSocketTimeout());
        connectionManager.setDefaultSocketConfig(socketConfig.build());
        RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        requestConfig.setConnectTimeout(settings.getConnectionTimeout());
        requestConfig.setConnectionRequestTimeout(settings.getConnectionRequestTimeout());
        requestConfig.setSocketTimeout(settings.getSocketTimeout());
        requestConfig.setCookieSpec("standard");
        return HttpClientBuilder.create().setUserAgent(StringUtils.isNotBlank((CharSequence)settings.getUserAgent()) ? String.format("%s %s", settings.getUserAgent(), this.getUserAgent()) : this.getUserAgent()).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig.build());
    }

    private String getUserAgent() {
        Package pkg = Package.getPackage("com.gooddata");
        String clientVersion = pkg != null && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : UNKNOWN_VERSION;
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)HttpClientBuilder.class.getClassLoader());
        String apacheVersion = vi != null ? vi.getRelease() : UNKNOWN_VERSION;
        return String.format("%s/%s (%s; %s) %s/%s", "GoodData-Java-SDK", clientVersion, System.getProperty("os.name"), System.getProperty("java.specification.version"), "Apache-HttpClient", apacheVersion);
    }

    private static String readApiVersion() {
        try {
            return StreamUtils.copyToString((InputStream)GoodData.class.getResourceAsStream("/GoodDataApiVersion"), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read GoodDataApiVersion from classpath", e);
        }
    }

    protected final RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected final HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void logout() {
        this.getAccountService().logout();
    }

    @Bean
    public ProjectService getProjectService() {
        return this.projectService;
    }

    @Bean
    public AccountService getAccountService() {
        return this.accountService;
    }

    @Bean
    public MetadataService getMetadataService() {
        return this.metadataService;
    }

    @Bean
    public ModelService getModelService() {
        return this.modelService;
    }

    @Bean
    public GdcService getGdcService() {
        return this.gdcService;
    }

    @Bean
    public DataStoreService getDataStoreService() {
        return this.dataStoreService;
    }

    @Bean
    public DatasetService getDatasetService() {
        return this.datasetService;
    }

    @Bean
    public ReportService getReportService() {
        return this.reportService;
    }

    @Bean
    public ExportService getExportService() {
        return this.exportService;
    }

    @Bean
    public ProcessService getProcessService() {
        return this.processService;
    }

    @Bean
    public WarehouseService getWarehouseService() {
        return this.warehouseService;
    }

    @Bean
    public ConnectorService getConnectorService() {
        return this.connectorService;
    }

    @Bean
    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    @Bean
    public ExportImportService getExportImportService() {
        return this.exportImportService;
    }

    @Bean
    public FeatureFlagService getFeatureFlagService() {
        return this.featureFlagService;
    }

    @Bean
    public OutputStageService getOutputStageService() {
        return this.outputStageService;
    }

    @Bean
    public ProjectTemplateService getProjectTemplateService() {
        return this.projectTemplateService;
    }

    @Bean
    public AuditEventService getAuditEventService() {
        return this.auditEventService;
    }

    @Bean
    public ExecuteAfmService getExecuteAfmService() {
        return this.executeAfmService;
    }

    @Bean
    public LcmService getLcmService() {
        return this.lcmService;
    }
}

