/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.util;

import com.gooddata.GoodDataRestException;
import com.gooddata.gdc.GdcError;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.util.List;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RestClientException;

public class ResponseErrorHandler
extends DefaultResponseErrorHandler {
    private final HttpMessageConverterExtractor<GdcError> gdcErrorExtractor;

    public ResponseErrorHandler(List<HttpMessageConverter<?>> messageConverters) {
        this.gdcErrorExtractor = new HttpMessageConverterExtractor(GdcError.class, Validate.noNullElements(messageConverters, "messageConverters"));
    }

    public void handleError(ClientHttpResponse response) {
        String statusText;
        int statusCode;
        GdcError error = null;
        try {
            error = (GdcError)this.gdcErrorExtractor.extractData(response);
        }
        catch (IOException | RestClientException throwable) {
            // empty catch block
        }
        String requestId = response.getHeaders().getFirst("X-GDC-REQUEST");
        try {
            statusCode = response.getRawStatusCode();
        }
        catch (IOException e) {
            statusCode = 0;
        }
        try {
            statusText = response.getStatusText();
        }
        catch (IOException e) {
            statusText = null;
        }
        throw new GoodDataRestException(statusCode, requestId, statusText, error);
    }
}

