/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.http.client.SimpleSSTRetrievalStrategy;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.httpcomponents.SingleEndpointGoodDataRestProvider;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class SstGoodDataRestProvider
extends SingleEndpointGoodDataRestProvider {
    public SstGoodDataRestProvider(GoodDataEndpoint endpoint, GoodDataSettings settings, String sst) {
        super(endpoint, settings, (HttpClientBuilder b, GoodDataEndpoint e, GoodDataSettings s) -> SstGoodDataRestProvider.createHttpClient(b, e, sst));
    }

    public static HttpClient createHttpClient(HttpClientBuilder builder, GoodDataEndpoint endpoint, String sst) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)builder, (String)"builder");
        Validate.notNull((Object)sst, (String)"sst");
        CloseableHttpClient httpClient = builder.build();
        SimpleSSTRetrievalStrategy strategy = new SimpleSSTRetrievalStrategy(sst);
        HttpHost httpHost = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getProtocol());
        return new GoodDataHttpClient((HttpClient)httpClient, httpHost, (SSTRetrievalStrategy)strategy);
    }
}

