/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import java.io.File;
import java.util.Arrays;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class XmlValidator {
    private XmlValidator() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length % 2 != 0) {
            System.err.println("Expected a non-zero number of xml-file xml-schema argument pairs: " + Arrays.toString(args));
            System.exit(1);
        }
        File[] files = new File[args.length];
        int errors = 0;
        for (int i = 0; i < args.length; ++i) {
            files[i] = new File(args[i]);
            if (files[i].canRead()) continue;
            System.err.println("Does not exist or cannot be read: " + files[i]);
            ++errors;
        }
        if (errors > 0) {
            System.exit(1);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        for (int i = 0; i < args.length; i += 2) {
            try {
                Schema schema = schemaFactory.newSchema(files[i + 1]);
                StreamSource xmlSource = new StreamSource(files[i]);
                schema.newValidator().validate(xmlSource);
                continue;
            }
            catch (SAXException e) {
                System.err.println("Validation of " + files[i] + " failed: " + e);
                ++errors;
            }
        }
        System.exit(errors == 0 ? 0 : 1);
    }
}

