/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.BaseService;
import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.Option;
import com.google.cloud.bigquery.QueryRequest;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.QueryResult;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

final class BigQueryImpl
extends BaseService<BigQueryOptions>
implements BigQuery {
    private final BigQueryRpc bigQueryRpc;

    BigQueryImpl(BigQueryOptions options) {
        super((ServiceOptions)options);
        this.bigQueryRpc = (BigQueryRpc)options.rpc();
    }

    @Override
    public Dataset create(DatasetInfo dataset, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = dataset.setProjectId(((BigQueryOptions)this.options()).projectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return Dataset.fromPb(this, (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.create(datasetPb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table create(TableInfo table, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = table.setProjectId(((BigQueryOptions)this.options()).projectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return Table.fromPb(this, (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.create(tablePb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Job create(JobInfo job, BigQuery.JobOption ... options) {
        final com.google.api.services.bigquery.model.Job jobPb = job.setProjectId(((BigQueryOptions)this.options()).projectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return Job.fromPb(this, (com.google.api.services.bigquery.model.Job)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Job>(){

                @Override
                public com.google.api.services.bigquery.model.Job call() {
                    return BigQueryImpl.this.bigQueryRpc.create(jobPb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Dataset getDataset(String datasetId, BigQuery.DatasetOption ... options) {
        return this.getDataset(DatasetId.of(datasetId), options);
    }

    @Override
    public Dataset getDataset(final DatasetId datasetId, BigQuery.DatasetOption ... options) {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Dataset answer = (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.getDataset(datasetId.dataset(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
            return answer == null ? null : Dataset.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Dataset> listDatasets(BigQuery.DatasetListOption ... options) {
        return BigQueryImpl.listDatasets((BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<Dataset> listDatasets(final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>>>(){

                @Override
                public BigQueryRpc.Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>> call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).listDatasets(optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = (String)result.x();
            return new PageImpl((PageImpl.NextPageFetcher)new DatasetPageFetcher(serviceOptions, cursor, optionsMap), cursor, Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Dataset, Dataset>(){

                public Dataset apply(com.google.api.services.bigquery.model.Dataset dataset) {
                    return Dataset.fromPb((BigQuery)serviceOptions.service(), dataset);
                }
            }));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, BigQuery.DatasetDeleteOption ... options) {
        return this.delete(DatasetId.of(datasetId), options);
    }

    @Override
    public boolean delete(final DatasetId datasetId, BigQuery.DatasetDeleteOption ... options) {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteDataset(datasetId.dataset(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, String tableId) {
        return this.delete(TableId.of(datasetId, tableId));
    }

    @Override
    public boolean delete(final TableId tableId) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteTable(tableId.dataset(), tableId.table());
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Dataset update(DatasetInfo dataset, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = dataset.setProjectId(((BigQueryOptions)this.options()).projectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return Dataset.fromPb(this, (com.google.api.services.bigquery.model.Dataset)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Dataset>(){

                @Override
                public com.google.api.services.bigquery.model.Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(datasetPb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table update(TableInfo table, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = table.setProjectId(((BigQueryOptions)this.options()).projectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return Table.fromPb(this, (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(tablePb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Table getTable(String datasetId, String tableId, BigQuery.TableOption ... options) {
        return this.getTable(TableId.of(datasetId, tableId), options);
    }

    @Override
    public Table getTable(final TableId tableId, BigQuery.TableOption ... options) {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Table answer = (com.google.api.services.bigquery.model.Table)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Table>(){

                @Override
                public com.google.api.services.bigquery.model.Table call() {
                    return BigQueryImpl.this.bigQueryRpc.getTable(tableId.dataset(), tableId.table(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
            return answer == null ? null : Table.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Table> listTables(String datasetId, BigQuery.TableListOption ... options) {
        return BigQueryImpl.listTables(datasetId, (BigQueryOptions)this.options(), this.optionMap(options));
    }

    @Override
    public Page<Table> listTables(DatasetId datasetId, BigQuery.TableListOption ... options) {
        return BigQueryImpl.listTables(datasetId.dataset(), (BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<Table> listTables(final String datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>>>(){

                @Override
                public BigQueryRpc.Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>> call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).listTables(datasetId, optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = (String)result.x();
            Iterable tables = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Table, Table>(){

                public Table apply(com.google.api.services.bigquery.model.Table table) {
                    return Table.fromPb((BigQuery)serviceOptions.service(), table);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new TablePageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, tables);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public InsertAllResponse insertAll(InsertAllRequest request) {
        TableId tableId = request.table();
        TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest();
        requestPb.setIgnoreUnknownValues(request.ignoreUnknownValues());
        requestPb.setSkipInvalidRows(request.skipInvalidRows());
        requestPb.setTemplateSuffix(request.templateSuffix());
        List rowsPb = Lists.transform(request.rows(), (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.id()).setJson(rowToInsert.content());
            }
        });
        requestPb.setRows(rowsPb);
        return InsertAllResponse.fromPb(this.bigQueryRpc.insertAll(tableId.dataset(), tableId.table(), requestPb));
    }

    @Override
    public Page<List<FieldValue>> listTableData(String datasetId, String tableId, BigQuery.TableDataListOption ... options) {
        return BigQueryImpl.listTableData(TableId.of(datasetId, tableId), (BigQueryOptions)this.options(), this.optionMap(options));
    }

    @Override
    public Page<List<FieldValue>> listTableData(TableId tableId, BigQuery.TableDataListOption ... options) {
        return BigQueryImpl.listTableData(tableId, (BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<List<FieldValue>> listTableData(final TableId tableId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<TableRow>>>(){

                @Override
                public BigQueryRpc.Tuple<String, Iterable<TableRow>> call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).listTableData(tableId.dataset(), tableId.table(), optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            String cursor = (String)result.x();
            return new PageImpl((PageImpl.NextPageFetcher)new TableDataPageFetcher(tableId, serviceOptions, cursor, optionsMap), cursor, BigQueryImpl.transformTableData((Iterable)result.y()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static List<List<FieldValue>> transformTableData(Iterable<TableRow> tableDataPb) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)(tableDataPb != null ? tableDataPb : ImmutableList.of()), (Function)new Function<TableRow, List<FieldValue>>(){

            public List<FieldValue> apply(TableRow rowPb) {
                return Lists.transform((List)rowPb.getF(), FieldValue.FROM_PB_FUNCTION);
            }
        }));
    }

    @Override
    public Job getJob(String jobId, BigQuery.JobOption ... options) {
        return this.getJob(JobId.of(jobId), options);
    }

    @Override
    public Job getJob(final JobId jobId, BigQuery.JobOption ... options) {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            com.google.api.services.bigquery.model.Job answer = (com.google.api.services.bigquery.model.Job)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.Job>(){

                @Override
                public com.google.api.services.bigquery.model.Job call() {
                    return BigQueryImpl.this.bigQueryRpc.getJob(jobId.job(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
            return answer == null ? null : Job.fromPb(this, answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<Job> listJobs(BigQuery.JobListOption ... options) {
        return BigQueryImpl.listJobs((BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<Job> listJobs(final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>>>(){

            @Override
            public BigQueryRpc.Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>> call() {
                return ((BigQueryRpc)serviceOptions.rpc()).listJobs(optionsMap);
            }
        }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
        String cursor = (String)result.x();
        Iterable jobs = Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<com.google.api.services.bigquery.model.Job, Job>(){

            public Job apply(com.google.api.services.bigquery.model.Job job) {
                return Job.fromPb((BigQuery)serviceOptions.service(), job);
            }
        });
        return new PageImpl((PageImpl.NextPageFetcher)new JobPageFetcher(serviceOptions, cursor, optionsMap), cursor, jobs);
    }

    @Override
    public boolean cancel(String jobId) {
        return this.cancel(JobId.of(jobId));
    }

    @Override
    public boolean cancel(final JobId jobId) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.cancel(jobId.job());
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public QueryResponse query(final QueryRequest request) {
        try {
            com.google.api.services.bigquery.model.QueryResponse results = (com.google.api.services.bigquery.model.QueryResponse)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.QueryResponse>(){

                @Override
                public com.google.api.services.bigquery.model.QueryResponse call() {
                    return BigQueryImpl.this.bigQueryRpc.query(request.setProjectId(((BigQueryOptions)BigQueryImpl.this.options()).projectId()).toPb());
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)((BigQueryOptions)this.options()).clock());
            QueryResponse.Builder builder = QueryResponse.builder();
            JobId completeJobId = JobId.fromPb(results.getJobReference());
            builder.jobId(completeJobId);
            builder.jobCompleted(results.getJobComplete());
            List rowsPb = results.getRows();
            if (results.getJobComplete().booleanValue()) {
                builder.jobCompleted(true);
                QueryResult.Builder resultBuilder = BigQueryImpl.transformQueryResults(completeJobId, rowsPb, results.getPageToken(), (BigQueryOptions)this.options(), ImmutableMap.of());
                resultBuilder.totalBytesProcessed(results.getTotalBytesProcessed());
                resultBuilder.cacheHit(results.getCacheHit());
                if (results.getSchema() != null) {
                    resultBuilder.schema(Schema.fromPb(results.getSchema()));
                }
                if (results.getTotalRows() != null) {
                    resultBuilder.totalRows(results.getTotalRows().longValue());
                }
                builder.result(resultBuilder.build());
            }
            if (results.getErrors() != null) {
                builder.executionErrors(Lists.transform((List)results.getErrors(), BigQueryError.FROM_PB_FUNCTION));
            }
            return builder.build();
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public QueryResponse getQueryResults(JobId job, BigQuery.QueryResultsOption ... options) {
        Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        return BigQueryImpl.getQueryResults(job, (BigQueryOptions)this.options(), optionsMap);
    }

    private static QueryResponse getQueryResults(final JobId jobId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            GetQueryResultsResponse results = (GetQueryResultsResponse)RetryHelper.runWithRetries((Callable)new Callable<GetQueryResultsResponse>(){

                @Override
                public GetQueryResultsResponse call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).getQueryResults(jobId.job(), optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER, (Clock)serviceOptions.clock());
            QueryResponse.Builder builder = QueryResponse.builder();
            JobId completeJobId = JobId.fromPb(results.getJobReference());
            builder.jobId(completeJobId);
            builder.etag(results.getEtag());
            builder.jobCompleted(results.getJobComplete());
            List rowsPb = results.getRows();
            if (results.getJobComplete().booleanValue()) {
                QueryResult.Builder resultBuilder = BigQueryImpl.transformQueryResults(completeJobId, rowsPb, results.getPageToken(), serviceOptions, ImmutableMap.of());
                resultBuilder.totalBytesProcessed(results.getTotalBytesProcessed());
                resultBuilder.cacheHit(results.getCacheHit());
                if (results.getSchema() != null) {
                    resultBuilder.schema(Schema.fromPb(results.getSchema()));
                }
                if (results.getTotalRows() != null) {
                    resultBuilder.totalRows(results.getTotalRows().longValue());
                }
                builder.result(resultBuilder.build());
            }
            if (results.getErrors() != null) {
                builder.executionErrors(Lists.transform((List)results.getErrors(), BigQueryError.FROM_PB_FUNCTION));
            }
            return builder.build();
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static QueryResult.Builder transformQueryResults(JobId jobId, List<TableRow> rowsPb, String cursor, BigQueryOptions serviceOptions, Map<BigQueryRpc.Option, ?> optionsMap) {
        QueryResultsPageFetcherImpl nextPageFetcher = new QueryResultsPageFetcherImpl(jobId, serviceOptions, cursor, optionsMap);
        return QueryResult.builder().pageFetcher(nextPageFetcher).cursor(cursor).results(BigQueryImpl.transformTableData(rowsPb));
    }

    @Override
    public TableDataWriteChannel writer(WriteChannelConfiguration writeChannelConfiguration) {
        return new TableDataWriteChannel((BigQueryOptions)this.options(), writeChannelConfiguration.setProjectId(((BigQueryOptions)this.options()).projectId()));
    }

    private Map<BigQueryRpc.Option, ?> optionMap(Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(BigQueryRpc.Option.class);
        for (Option option : options) {
            Object prev = optionMap.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        return optionMap;
    }

    private static class QueryResultsPageFetcherImpl
    implements PageImpl.NextPageFetcher<List<FieldValue>>,
    QueryResult.QueryResultsPageFetcher {
        private static final long serialVersionUID = -9198905840550459803L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final JobId job;

        QueryResultsPageFetcherImpl(JobId job, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.job = job;
        }

        @Override
        public QueryResult nextPage() {
            return BigQueryImpl.getQueryResults(this.job, this.serviceOptions, this.requestOptions).result();
        }
    }

    private static class TableDataPageFetcher
    implements PageImpl.NextPageFetcher<List<FieldValue>> {
        private static final long serialVersionUID = -8501991114794410114L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final TableId table;

        TableDataPageFetcher(TableId table, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.table = table;
        }

        public Page<List<FieldValue>> nextPage() {
            return BigQueryImpl.listTableData(this.table, this.serviceOptions, this.requestOptions);
        }
    }

    private static class JobPageFetcher
    implements PageImpl.NextPageFetcher<Job> {
        private static final long serialVersionUID = 8536533282558245472L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;

        JobPageFetcher(BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Job> nextPage() {
            return BigQueryImpl.listJobs(this.serviceOptions, this.requestOptions);
        }
    }

    private static class TablePageFetcher
    implements PageImpl.NextPageFetcher<Table> {
        private static final long serialVersionUID = 8611248840504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final String dataset;

        TablePageFetcher(String dataset, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.dataset = dataset;
        }

        public Page<Table> nextPage() {
            return BigQueryImpl.listTables(this.dataset, this.serviceOptions, this.requestOptions);
        }
    }

    private static class DatasetPageFetcher
    implements PageImpl.NextPageFetcher<Dataset> {
        private static final long serialVersionUID = -3057564042439021278L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;

        DatasetPageFetcher(BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Dataset> nextPage() {
            return BigQueryImpl.listDatasets(this.serviceOptions, this.requestOptions);
        }
    }
}

