/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.testing;

import com.google.cloud.AuthCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.compute.ComputeOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteComputeHelper {
    private static final Logger log = Logger.getLogger(RemoteComputeHelper.class.getName());
    private final ComputeOptions options;

    private RemoteComputeHelper(ComputeOptions options) {
        this.options = options;
    }

    public ComputeOptions options() {
        return this.options;
    }

    public static String baseResourceName() {
        return "test-" + UUID.randomUUID().toString().replace("-", "").substring(0, 24) + "-";
    }

    public static RemoteComputeHelper create(String projectId, InputStream keyStream) {
        try {
            ComputeOptions computeOptions = ((ComputeOptions.Builder)((ComputeOptions.Builder)((ComputeOptions.Builder)((ComputeOptions.Builder)((ComputeOptions.Builder)ComputeOptions.builder().authCredentials((AuthCredentials)AuthCredentials.createForJson((InputStream)keyStream))).projectId(projectId)).retryParams(RemoteComputeHelper.retryParams())).connectTimeout(60000)).readTimeout(60000)).build();
            return new RemoteComputeHelper(computeOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw ComputeHelperException.translate(ex);
        }
    }

    public static RemoteComputeHelper create() {
        ComputeOptions computeOptions = ((ComputeOptions.Builder)((ComputeOptions.Builder)((ComputeOptions.Builder)ComputeOptions.builder().retryParams(RemoteComputeHelper.retryParams())).connectTimeout(60000)).readTimeout(60000)).build();
        return new RemoteComputeHelper(computeOptions);
    }

    private static RetryParams retryParams() {
        return RetryParams.builder().retryMaxAttempts(10).retryMinAttempts(6).maxRetryDelayMillis(30000L).totalRetryPeriodMillis(120000L).initialRetryDelayMillis(250L).build();
    }

    public static class ComputeHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -5747977015007639912L;

        public ComputeHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static ComputeHelperException translate(Exception ex) {
            return new ComputeHelperException(ex.getMessage(), ex);
        }
    }
}

