/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.AsyncPage;
import com.google.cloud.AsyncPageImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;

public class AsyncPageImplTest {
    private static final ImmutableList<String> VALUES1 = ImmutableList.of((Object)"1", (Object)"2");
    private static final ImmutableList<String> VALUES2 = ImmutableList.of((Object)"3", (Object)"4");
    private static final ImmutableList<String> VALUES3 = ImmutableList.of((Object)"5", (Object)"6");
    private static final ImmutableList<String> ALL_VALUES = ImmutableList.builder().addAll(VALUES1).addAll(VALUES2).addAll(VALUES3).build();
    private static final ImmutableList<String> SOME_VALUES = ImmutableList.builder().addAll(VALUES2).addAll(VALUES3).build();

    @Test
    public void testPage() {
        final AsyncPageImpl nextResult = new AsyncPageImpl(null, "c", VALUES2);
        AsyncPageImpl.NextPageFetcher<String> fetcher = new AsyncPageImpl.NextPageFetcher<String>(){
            private static final long serialVersionUID = 4703765400378593176L;

            public Future<AsyncPage<String>> nextPage() {
                return Futures.immediateFuture((Object)nextResult);
            }
        };
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher, "c", VALUES1);
        Assert.assertEquals((Object)nextResult, (Object)result.nextPage());
        Assert.assertEquals((Object)"c", (Object)result.nextPageCursor());
        Assert.assertEquals(VALUES1, (Object)result.values());
    }

    @Test
    public void testPageAsync() throws ExecutionException, InterruptedException {
        final AsyncPageImpl nextResult = new AsyncPageImpl(null, "c", VALUES2);
        AsyncPageImpl.NextPageFetcher<String> fetcher = new AsyncPageImpl.NextPageFetcher<String>(){
            private static final long serialVersionUID = 4703765400378593176L;

            public Future<AsyncPage<String>> nextPage() {
                return Futures.immediateFuture((Object)nextResult);
            }
        };
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher, "c", VALUES1);
        Assert.assertEquals((Object)nextResult, result.nextPageAsync().get());
        Assert.assertEquals((Object)"c", (Object)result.nextPageCursor());
        Assert.assertEquals(VALUES1, (Object)result.values());
    }

    @Test
    public void testIterateAll() {
        final AsyncPageImpl nextResult2 = new AsyncPageImpl(null, "c3", VALUES3);
        AsyncPageImpl.NextPageFetcher<String> fetcher2 = new AsyncPageImpl.NextPageFetcher<String>(){
            private static final long serialVersionUID = -9203621430631884026L;

            public Future<AsyncPage<String>> nextPage() {
                return Futures.immediateFuture((Object)nextResult2);
            }
        };
        final AsyncPageImpl nextResult1 = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher2, "c2", VALUES2);
        AsyncPageImpl.NextPageFetcher<String> fetcher1 = new AsyncPageImpl.NextPageFetcher<String>(){
            private static final long serialVersionUID = -9203621430631884026L;

            public Future<AsyncPage<String>> nextPage() {
                return Futures.immediateFuture((Object)nextResult1);
            }
        };
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher1, "c1", VALUES1);
        Assert.assertEquals(ALL_VALUES, (Object)ImmutableList.copyOf((Iterator)result.iterateAll()));
    }

    @Test
    public void testAsyncPageAndIterateAll() throws ExecutionException, InterruptedException {
        final AsyncPageImpl nextResult2 = new AsyncPageImpl(null, "c3", VALUES3);
        AsyncPageImpl.NextPageFetcher<String> fetcher2 = new AsyncPageImpl.NextPageFetcher<String>(){
            private static final long serialVersionUID = -9203621430631884026L;

            public Future<AsyncPage<String>> nextPage() {
                return Futures.immediateFuture((Object)nextResult2);
            }
        };
        final AsyncPageImpl nextResult1 = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher2, "c2", VALUES2);
        AsyncPageImpl.NextPageFetcher<String> fetcher1 = new AsyncPageImpl.NextPageFetcher<String>(){
            private static final long serialVersionUID = -9203621430631884026L;

            public Future<AsyncPage<String>> nextPage() {
                return Futures.immediateFuture((Object)nextResult1);
            }
        };
        AsyncPageImpl result = new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)fetcher1, "c1", VALUES1);
        Assert.assertEquals((Object)nextResult1, result.nextPageAsync().get());
        Assert.assertEquals((Object)"c1", (Object)result.nextPageCursor());
        Assert.assertEquals(VALUES1, (Object)result.values());
        Assert.assertEquals(SOME_VALUES, (Object)ImmutableList.copyOf((Iterator)((AsyncPage)result.nextPageAsync().get()).iterateAll()));
    }
}

