/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.AuthCredentials;
import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AuthCredentialsTest {
    private static final String ACCESS_TOKEN = "accessToken";
    private static final Date EXPIRATION_DATE = new Date();
    private static final String SERVICE_ACCOUNT = "someclientid@developer.gserviceaccount.com";
    private static final String PRIVATE_KEY_STRING = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAL2xolH1zrISQ8+GzOV29BNjjzq4/HIP8Psd1+cZb81vDklSF+95wB250MSE0BDc81pvIMwj5OmIfLg1NY6uB1xavOPpVdx1z664AGc/BEJ1zInXGXaQ6s+SxGenVq40Yws57gikQGMZjttpf1Qbz4DjkxsbRoeaRHn06n9pH1ejAgMBAAECgYEAkWcm0AJF5LMhbWKbjkxm/LG06UNApkHX6vTOOOODkonM/qDBnhvKCj8Tan+PaU2j7679Cd19qxCm4SBQJET7eBhqLD9L2j9y0h2YUQnLbISaqUS1/EXcr2C1Lf9VCEn1y/GYuDYqs85rGoQ4ZYfM9ClROSq86fH+cbIIssqJqukCQQD18LjfJz/ichFeli5/l1jaFid2XoCH3T6TVuuysszVx68fh60gSIxEF/0X2xB+wuPxTP4IQ+t8tD/ktd232oWXAkEAxXPych2QBHePk9/lek4tOkKBgfnDzex7S/pI0G1vpB3VmzBbCsokn9lpOv7JV8071GDlW/7R6jlLfpQy3hN31QJAE10osSk99m5Uv8XDU3hvHnywDrnSFOBulNs7I47AYfSe7TSZhPkxUgsxejddTR27JLyTI8N1PxRSE4feNSOXcQJAMMKJRJT4U6IS2rmXubREhvaVdLtxFxEnAYQ1JwNfZm/XqBMw6GEy2iaeTetNXVlZRQEIoscyn1y2v/No/F5iYQJBAKBOGASoQcBjGTOg/H/SfcE8QVNsKEpthRrs6CkpT80aZ/AV+ksfoIf2zw2M3mAHfrO+TBLdz4sicuFQvlN9SEc=";
    private static final String JSON_KEY = "{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAL2xolH1zrISQ8+GzOV29BNjjzq4/HIP8Psd1+cZb81vDklSF+95wB250MSE0BDc81pvIMwj5OmIfLg1NY6uB1xavOPpVdx1z664AGc/BEJ1zInXGXaQ6s+SxGenVq40Yws57gikQGMZjttpf1Qbz4DjkxsbRoeaRHn06n9pH1ejAgMBAAECgYEAkWcm0AJF5LMhbWKbjkxm/LG06UNApkHX6vTOOOODkonM/qDBnhvKCj8Tan+PaU2j7679Cd19qxCm4SBQJET7eBhqLD9L2j9y0h2YUQnLbISaqUS1/EXcr2C1Lf9VCEn1y/GYuDYqs85rGoQ4ZYfM9ClROSq86fH+cbIIssqJqukCQQD18LjfJz/ichFeli5/l1jaFid2XoCH3T6TVuuysszVx68fh60gSIxEF/0X2xB+wuPxTP4IQ+t8tD/ktd232oWXAkEAxXPych2QBHePk9/lek4tOkKBgfnDzex7S/pI0G1vpB3VmzBbCsokn9lpOv7JV8071GDlW/7R6jlLfpQy3hN31QJAE10osSk99m5Uv8XDU3hvHnywDrnSFOBulNs7I47AYfSe7TSZhPkxUgsxejddTR27JLyTI8N1PxRSE4feNSOXcQJAMMKJRJT4U6IS2rmXubREhvaVdLtxFxEnAYQ1JwNfZm/XqBMw6GEy2iaeTetNXVlZRQEIoscyn1y2v/No/F5iYQJBAKBOGASoQcBjGTOg/H/SfcE8QVNsKEpthRrs6CkpT80aZ/AV+ksfoIf2zw2M3mAHfrO+TBLdz4sicuFQvlN9SEc=\\n-----END PRIVATE KEY-----\\n\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\"\n}";
    private static final AuthCredentials NO_AUTH_CREDENTIALS = AuthCredentials.noAuth();
    private static final AuthCredentials.OAuth2AuthCredentials OAUTH2_AUTH_CREDENTIALS = AuthCredentials.createFor((String)"accessToken", (Date)EXPIRATION_DATE);
    private static final byte[] BYTES_TO_SIGN = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAL2xolH1zrISQ8+GzOV29BNjjzq4/HIP8Psd1+cZb81vDklSF+95wB250MSE0BDc81pvIMwj5OmIfLg1NY6uB1xavOPpVdx1z664AGc/BEJ1zInXGXaQ6s+SxGenVq40Yws57gikQGMZjttpf1Qbz4DjkxsbRoeaRHn06n9pH1ejAgMBAAECgYEAkWcm0AJF5LMhbWKbjkxm/LG06UNApkHX6vTOOOODkonM/qDBnhvKCj8Tan+PaU2j7679Cd19qxCm4SBQJET7eBhqLD9L2j9y0h2YUQnLbISaqUS1/EXcr2C1Lf9VCEn1y/GYuDYqs85rGoQ4ZYfM9ClROSq86fH+cbIIssqJqukCQQD18LjfJz/ichFeli5/l1jaFid2XoCH3T6TVuuysszVx68fh60gSIxEF/0X2xB+wuPxTP4IQ+t8tD/ktd232oWXAkEAxXPych2QBHePk9/lek4tOkKBgfnDzex7S/pI0G1vpB3VmzBbCsokn9lpOv7JV8071GDlW/7R6jlLfpQy3hN31QJAE10osSk99m5Uv8XDU3hvHnywDrnSFOBulNs7I47AYfSe7TSZhPkxUgsxejddTR27JLyTI8N1PxRSE4feNSOXcQJAMMKJRJT4U6IS2rmXubREhvaVdLtxFxEnAYQ1JwNfZm/XqBMw6GEy2iaeTetNXVlZRQEIoscyn1y2v/No/F5iYQJBAKBOGASoQcBjGTOg/H/SfcE8QVNsKEpthRrs6CkpT80aZ/AV+ksfoIf2zw2M3mAHfrO+TBLdz4sicuFQvlN9SEc=".getBytes(Charsets.UTF_8);
    private static PrivateKey privateKey;
    private static byte[] signedBytes;

    @BeforeClass
    public static void beforeClass() throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(BaseEncoding.base64().decode((CharSequence)PRIVATE_KEY_STRING)));
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(BYTES_TO_SIGN);
        signedBytes = signature.sign();
    }

    @Test
    public void testNoAuthCredentials() {
        Assert.assertSame((Object)NO_AUTH_CREDENTIALS, (Object)AuthCredentials.noAuth());
        Assert.assertNull((Object)NO_AUTH_CREDENTIALS.credentials());
    }

    @Test
    public void testOAuth2AuthCredentials() {
        AccessToken accessToken = OAUTH2_AUTH_CREDENTIALS.credentials().getAccessToken();
        Assert.assertEquals((Object)ACCESS_TOKEN, (Object)accessToken.getTokenValue());
        Assert.assertEquals((Object)EXPIRATION_DATE, (Object)accessToken.getExpirationTime());
        AuthCredentials.OAuth2AuthCredentials oAuth2AuthCredentials = AuthCredentials.createFor((String)ACCESS_TOKEN);
        accessToken = oAuth2AuthCredentials.credentials().getAccessToken();
        Assert.assertEquals((Object)ACCESS_TOKEN, (Object)accessToken.getTokenValue());
        Assert.assertNull((Object)accessToken.getExpirationTime());
    }

    @Test
    public void testServiceAccountFromJson() throws IOException, SignatureException {
        AuthCredentials.ServiceAccountAuthCredentials serviceAccountAuthCredentials = AuthCredentials.createForJson((InputStream)new ByteArrayInputStream(JSON_KEY.getBytes()));
        ServiceAccountCredentials credentials = serviceAccountAuthCredentials.credentials();
        Assert.assertEquals((Object)SERVICE_ACCOUNT, (Object)serviceAccountAuthCredentials.account());
        Assert.assertEquals((Object)SERVICE_ACCOUNT, (Object)credentials.getClientEmail());
        Assert.assertEquals((Object)privateKey, (Object)credentials.getPrivateKey());
        Assert.assertArrayEquals((byte[])signedBytes, (byte[])serviceAccountAuthCredentials.sign(BYTES_TO_SIGN));
    }

    @Test
    public void testServiceAccountFromKey() throws IOException, SignatureException {
        AuthCredentials.ServiceAccountAuthCredentials serviceAccountAuthCredentials = AuthCredentials.createFor((String)SERVICE_ACCOUNT, (PrivateKey)privateKey);
        ServiceAccountCredentials credentials = serviceAccountAuthCredentials.credentials();
        Assert.assertEquals((Object)SERVICE_ACCOUNT, (Object)serviceAccountAuthCredentials.account());
        Assert.assertEquals((Object)SERVICE_ACCOUNT, (Object)credentials.getClientEmail());
        Assert.assertEquals((Object)privateKey, (Object)credentials.getPrivateKey());
        Assert.assertArrayEquals((byte[])signedBytes, (byte[])serviceAccountAuthCredentials.sign(BYTES_TO_SIGN));
    }
}

