/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class BaseServiceExceptionTest {
    private static final int CODE = 1;
    private static final int CODE_NO_REASON = 2;
    private static final String MESSAGE = "some message";
    private static final String REASON = "some reason";
    private static final boolean RETRYABLE = true;
    private static final boolean IDEMPOTENT = true;

    @Test
    public void testBaseServiceException() {
        BaseServiceException serviceException = new BaseServiceException(1, MESSAGE, REASON, true);
        Assert.assertEquals((long)1L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.reason());
        Assert.assertFalse((boolean)serviceException.retryable());
        Assert.assertEquals((Object)true, (Object)serviceException.idempotent());
        Assert.assertNull((Object)serviceException.getCause());
        serviceException = new BaseServiceException(1, MESSAGE, REASON, true);
        Assert.assertEquals((long)1L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.reason());
        Assert.assertFalse((boolean)serviceException.retryable());
        Assert.assertEquals((Object)true, (Object)serviceException.idempotent());
        Assert.assertNull((Object)serviceException.getCause());
        RuntimeException cause = new RuntimeException();
        serviceException = new BaseServiceException(1, MESSAGE, REASON, true, (Throwable)cause);
        Assert.assertEquals((long)1L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.reason());
        Assert.assertFalse((boolean)serviceException.retryable());
        Assert.assertEquals((Object)true, (Object)serviceException.idempotent());
        Assert.assertEquals((Object)cause, (Object)serviceException.getCause());
        serviceException = new BaseServiceException(1, MESSAGE, REASON, false, (Throwable)cause);
        Assert.assertEquals((long)1L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.reason());
        Assert.assertFalse((boolean)serviceException.retryable());
        Assert.assertFalse((boolean)serviceException.idempotent());
        Assert.assertEquals((Object)cause, (Object)serviceException.getCause());
        SocketTimeoutException exception = new SocketTimeoutException();
        serviceException = new BaseServiceException((IOException)exception, true);
        Assert.assertTrue((boolean)serviceException.retryable());
        Assert.assertTrue((boolean)serviceException.idempotent());
        Assert.assertEquals((Object)exception, (Object)serviceException.getCause());
        GoogleJsonError error = new GoogleJsonError();
        error.setCode(1);
        error.setMessage(MESSAGE);
        serviceException = new BaseServiceException(error, true);
        Assert.assertEquals((long)1L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertFalse((boolean)serviceException.retryable());
        Assert.assertTrue((boolean)serviceException.idempotent());
        serviceException = new CustomServiceException(1, MESSAGE, REASON, true);
        Assert.assertEquals((long)1L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.reason());
        Assert.assertEquals((Object)true, (Object)serviceException.retryable());
        Assert.assertEquals((Object)true, (Object)serviceException.idempotent());
        serviceException = new CustomServiceException(2, MESSAGE, null, true);
        Assert.assertEquals((long)2L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertNull((Object)serviceException.reason());
        Assert.assertEquals((Object)true, (Object)serviceException.retryable());
        Assert.assertEquals((Object)true, (Object)serviceException.idempotent());
        serviceException = new CustomServiceException(0, MESSAGE, REASON, true);
        Assert.assertEquals((long)0L, (long)serviceException.code());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.reason());
        Assert.assertEquals((Object)true, (Object)serviceException.retryable());
        Assert.assertEquals((Object)true, (Object)serviceException.idempotent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        BaseServiceException cause = new BaseServiceException(1, MESSAGE, REASON, true);
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            BaseServiceException.translateAndPropagateIfPossible((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)1L, (long)ex.code());
                Assert.assertEquals((Object)MESSAGE, (Object)ex.getMessage());
                Assert.assertFalse((boolean)ex.retryable());
                Assert.assertEquals((Object)true, (Object)ex.idempotent());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }

    private static class CustomServiceException
    extends BaseServiceException {
        private static final long serialVersionUID = -195251309124875103L;

        public CustomServiceException(int code, String message, String reason, boolean idempotent) {
            super(code, message, reason, idempotent);
        }

        protected Set<BaseServiceException.Error> retryableErrors() {
            return ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(1), BaseServiceExceptionTest.REASON), (Object)new BaseServiceException.Error(null, BaseServiceExceptionTest.REASON), (Object)new BaseServiceException.Error(Integer.valueOf(2), null));
        }
    }
}

