/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.BaseWriteChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.spi.ServiceRpcFactory;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BaseWriteChannelTest {
    private static final Serializable ENTITY = Long.valueOf(42L);
    private static final String UPLOAD_ID = "uploadId";
    private static final byte[] CONTENT = new byte[]{13, 14, 10, 13};
    private static final int MIN_CHUNK_SIZE = 262144;
    private static final int DEFAULT_CHUNK_SIZE = 0x200000;
    private static final Random RANDOM = new Random();
    private static BaseWriteChannel channel;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        channel = new BaseWriteChannel<CustomServiceOptions, Serializable>(null, ENTITY, UPLOAD_ID){

            public RestorableState<WriteChannel> capture() {
                return null;
            }

            protected void flushBuffer(int length, boolean last) {
            }

            protected BaseWriteChannel.BaseState.Builder<CustomServiceOptions, Serializable> stateBuilder() {
                return null;
            }
        };
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals(null, (Object)channel.options());
        Assert.assertEquals((Object)ENTITY, (Object)channel.entity());
        Assert.assertEquals((long)0L, (long)channel.position());
        Assert.assertEquals((Object)UPLOAD_ID, (Object)channel.uploadId());
        Assert.assertEquals((long)0L, (long)channel.limit());
        TestCase.assertTrue((boolean)channel.isOpen());
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])channel.buffer());
        Assert.assertEquals((long)0x200000L, (long)channel.chunkSize());
    }

    @Test
    public void testClose() throws IOException {
        channel.close();
        TestCase.assertFalse((boolean)channel.isOpen());
        Assert.assertNull((Object)channel.buffer());
    }

    @Test
    public void testValidateOpen() throws IOException {
        channel.close();
        this.thrown.expect(ClosedChannelException.class);
        channel.write(ByteBuffer.allocate(42));
    }

    @Test
    public void testChunkSize() {
        channel.chunkSize(42);
        Assert.assertEquals((long)262144L, (long)channel.chunkSize());
        channel.chunkSize(524288);
        Assert.assertEquals((long)524288L, (long)channel.chunkSize());
        channel.chunkSize(524800);
        Assert.assertEquals((long)524288L, (long)channel.chunkSize());
    }

    @Test
    public void testWrite() throws IOException {
        channel.write(ByteBuffer.wrap(CONTENT));
        Assert.assertEquals((long)CONTENT.length, (long)channel.limit());
        Assert.assertEquals((long)0x200000L, (long)channel.buffer().length);
        Assert.assertArrayEquals((byte[])Arrays.copyOf(CONTENT, 0x200000), (byte[])channel.buffer());
    }

    @Test
    public void testWriteAndFlush() throws IOException {
        ByteBuffer content = BaseWriteChannelTest.randomBuffer(0x200001);
        channel.write(content);
        Assert.assertEquals((long)0x200000L, (long)channel.position());
        Assert.assertEquals((long)1L, (long)channel.limit());
        byte[] newContent = new byte[0x200000];
        newContent[0] = content.get(0x200000);
        Assert.assertArrayEquals((byte[])newContent, (byte[])channel.buffer());
    }

    private static ByteBuffer randomBuffer(int size) {
        byte[] byteArray = new byte[size];
        RANDOM.nextBytes(byteArray);
        return ByteBuffer.wrap(byteArray);
    }

    private static abstract class CustomServiceOptions
    extends ServiceOptions<CustomService, Object, CustomServiceOptions> {
        private static final long serialVersionUID = 3302358029307467197L;

        protected CustomServiceOptions(Class<? extends ServiceFactory<CustomService, CustomServiceOptions>> serviceFactoryClass, Class<? extends ServiceRpcFactory<Object, CustomServiceOptions>> rpcFactoryClass, ServiceOptions.Builder<CustomService, Object, CustomServiceOptions, ?> builder) {
            super(serviceFactoryClass, rpcFactoryClass, builder);
        }
    }

    private static abstract class CustomService
    implements Service<CustomServiceOptions> {
        private CustomService() {
        }
    }
}

