/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.BaseServiceException;
import com.google.cloud.BatchResult;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BatchResultTest {
    private BatchResult<Boolean, BaseServiceException> result;

    @Before
    public void setUp() {
        this.result = new BatchResult<Boolean, BaseServiceException>(){};
    }

    @Test
    public void testSuccess() {
        Assert.assertFalse((boolean)this.result.completed());
        try {
            this.result.get();
            Assert.fail((String)"This was not completed yet.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.result.success((Object)true);
        Assert.assertTrue((boolean)((Boolean)this.result.get()));
        this.result.success(null);
    }

    @Test
    public void testError() {
        Assert.assertFalse((boolean)this.result.completed());
        try {
            this.result.get();
            Assert.fail((String)"This was not completed yet.");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            this.result.error(null);
            Assert.fail();
        }
        catch (NullPointerException exc) {
            // empty catch block
        }
        BaseServiceException ex = new BaseServiceException(0, "message", "reason", false);
        this.result.error(ex);
        try {
            this.result.get();
            Assert.fail((String)"This is a failed operation and should have thrown a DnsException.");
        }
        catch (BaseServiceException real) {
            Assert.assertSame((Object)((Object)ex), (Object)((Object)real));
        }
    }

    @Test
    public void testNotifyError() {
        BaseServiceException ex = new BaseServiceException(0, "message", "reason", false);
        Assert.assertFalse((boolean)this.result.completed());
        BatchResult.Callback callback = (BatchResult.Callback)EasyMock.createStrictMock(BatchResult.Callback.class);
        callback.error((Object)ex);
        EasyMock.replay((Object[])new Object[]{callback});
        this.result.notify(callback);
        this.result.error(ex);
        try {
            this.result.notify(callback);
            Assert.fail((String)"The batch has been completed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{callback});
    }

    @Test
    public void testNotifySuccess() {
        Assert.assertFalse((boolean)this.result.completed());
        BatchResult.Callback callback = (BatchResult.Callback)EasyMock.createStrictMock(BatchResult.Callback.class);
        callback.success((Object)true);
        EasyMock.replay((Object[])new Object[]{callback});
        this.result.notify(callback);
        this.result.success((Object)true);
        try {
            this.result.notify(callback);
            Assert.fail((String)"The batch has been completed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{callback});
    }
}

