/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.ExceptionHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExceptionHandlerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testVerifyCaller() {
        ExceptionHandler handler = ExceptionHandler.defaultInstance();
        class A
        implements Callable<Object> {
            A() {
            }

            @Override
            public Object call() throws IOException, InterruptedException {
                return null;
            }
        }
        ExceptionHandlerTest.assertValidCallable(new A(), handler);
        class B
        extends A {
            B() {
            }
        }
        ExceptionHandlerTest.assertValidCallable(new B(), handler);
        class C
        extends A {
            C() {
            }

            @Override
            public Object call() throws FileNotFoundException {
                return "c";
            }
        }
        ExceptionHandlerTest.assertValidCallable(new C(), handler);
        class D
        extends C {
            D() {
            }

            @Override
            public Object call() throws IllegalArgumentException {
                return "d";
            }
        }
        ExceptionHandlerTest.assertValidCallable(new D(), handler);
        class E
        extends A {
            E() {
            }

            @Override
            public String call() throws NullPointerException {
                return "e";
            }
        }
        ExceptionHandlerTest.assertValidCallable(new E(), handler);
        class F
        extends A {
            F() {
            }

            @Override
            public Object call() throws Error {
                return "f";
            }
        }
        ExceptionHandlerTest.assertInvalidCallable(new F(), handler);
        handler = ExceptionHandler.builder().retryOn(new Class[]{FileNotFoundException.class, NullPointerException.class}).build();
        ExceptionHandlerTest.assertInvalidCallable(new A(), handler);
        ExceptionHandlerTest.assertInvalidCallable(new B(), handler);
        ExceptionHandlerTest.assertValidCallable(new C(), handler);
        ExceptionHandlerTest.assertInvalidCallable(new D(), handler);
        ExceptionHandlerTest.assertValidCallable(new E(), handler);
        ExceptionHandlerTest.assertInvalidCallable(new F(), handler);
    }

    private static <T> void assertValidCallable(Callable<T> callable, ExceptionHandler handler) {
        handler.verifyCaller(callable);
    }

    private static <T> void assertInvalidCallable(Callable<T> callable, ExceptionHandler handler) {
        try {
            handler.verifyCaller(callable);
            Assert.fail((String)"Expected RetryHelper constructor to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testShouldTry() {
        ExceptionHandler handler = ExceptionHandler.builder().retryOn(new Class[]{IOException.class}).build();
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new IOException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new ClosedByInterruptException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new RuntimeException()));
        ExceptionHandler.Builder builder = ExceptionHandler.builder().retryOn(new Class[]{IOException.class, NullPointerException.class}).abortOn(new Class[]{RuntimeException.class, ClosedByInterruptException.class, InterruptedException.class});
        handler = builder.build();
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new IOException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new ClosedByInterruptException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new InterruptedException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new RuntimeException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new NullPointerException()));
        final AtomicReference<ExceptionHandler.Interceptor.RetryResult> before = new AtomicReference<ExceptionHandler.Interceptor.RetryResult>(ExceptionHandler.Interceptor.RetryResult.NO_RETRY);
        ExceptionHandler.Interceptor interceptor = new ExceptionHandler.Interceptor(){

            public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
                return retryResult == ExceptionHandler.Interceptor.RetryResult.NO_RETRY ? ExceptionHandler.Interceptor.RetryResult.RETRY : ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
            }

            public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
                return (ExceptionHandler.Interceptor.RetryResult)before.get();
            }
        };
        builder.interceptor(new ExceptionHandler.Interceptor[]{interceptor});
        handler = builder.build();
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new IOException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new ClosedByInterruptException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new InterruptedException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new RuntimeException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new NullPointerException()));
        before.set(ExceptionHandler.Interceptor.RetryResult.RETRY);
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new IOException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new ClosedByInterruptException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new InterruptedException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new RuntimeException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new NullPointerException()));
        before.set(ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION);
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new IOException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new ClosedByInterruptException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new InterruptedException()));
        Assert.assertTrue((boolean)handler.shouldRetry((Exception)new RuntimeException()));
        Assert.assertFalse((boolean)handler.shouldRetry((Exception)new NullPointerException()));
    }

    @Test
    public void testNullRetryResultFromBeforeEval() {
        ExceptionHandler.Interceptor interceptor = new ExceptionHandler.Interceptor(){

            public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
                return null;
            }

            public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
                return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
            }
        };
        ExceptionHandler handler = ExceptionHandler.builder().interceptor(new ExceptionHandler.Interceptor[]{interceptor}).build();
        this.thrown.expect(NullPointerException.class);
        handler.shouldRetry(new Exception());
    }

    @Test
    public void testNullRetryResultFromAfterEval() {
        ExceptionHandler.Interceptor interceptor = new ExceptionHandler.Interceptor(){

            public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
                return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
            }

            public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
                return null;
            }
        };
        ExceptionHandler handler = ExceptionHandler.builder().interceptor(new ExceptionHandler.Interceptor[]{interceptor}).build();
        this.thrown.expect(NullPointerException.class);
        handler.shouldRetry(new Exception());
    }
}

