/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.BaseService;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class GrpcServiceOptionsTest {
    private static final GrpcServiceOptions.ExecutorFactory MOCK_EXECUTOR_FACTORY = (GrpcServiceOptions.ExecutorFactory)EasyMock.createMock(GrpcServiceOptions.ExecutorFactory.class);
    private static final TestGrpcServiceOptions OPTIONS = ((TestGrpcServiceOptions.Builder)((TestGrpcServiceOptions.Builder)((TestGrpcServiceOptions.Builder)((TestGrpcServiceOptions.Builder)((TestGrpcServiceOptions.Builder)TestGrpcServiceOptions.access$000().projectId("project-id")).initialTimeout(1234)).timeoutMultiplier(1.6)).maxTimeout(5678)).executorFactory(MOCK_EXECUTOR_FACTORY)).build();
    private static final TestGrpcServiceOptions DEFAULT_OPTIONS = ((TestGrpcServiceOptions.Builder)TestGrpcServiceOptions.access$000().projectId("project-id")).build();
    private static final TestGrpcServiceOptions OPTIONS_COPY = OPTIONS.toBuilder().build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((long)1234L, (long)OPTIONS.initialTimeout());
        Assert.assertEquals((double)1.6, (double)OPTIONS.timeoutMultiplier(), (double)0.0);
        Assert.assertEquals((long)5678L, (long)OPTIONS.maxTimeout());
        Assert.assertSame((Object)MOCK_EXECUTOR_FACTORY, (Object)OPTIONS.executorFactory());
        Assert.assertEquals((long)20000L, (long)DEFAULT_OPTIONS.initialTimeout());
        Assert.assertEquals((double)1.5, (double)DEFAULT_OPTIONS.timeoutMultiplier(), (double)0.0);
        Assert.assertEquals((long)100000L, (long)DEFAULT_OPTIONS.maxTimeout());
        Assert.assertTrue((boolean)(DEFAULT_OPTIONS.executorFactory() instanceof GrpcServiceOptions.DefaultExecutorFactory));
    }

    @Test
    public void testBuilderError() {
        try {
            TestGrpcServiceOptions.builder().initialTimeout(0);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Initial timeout must be > 0", (Object)ex.getMessage());
        }
        try {
            TestGrpcServiceOptions.builder().initialTimeout(-1);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Initial timeout must be > 0", (Object)ex.getMessage());
        }
        try {
            TestGrpcServiceOptions.builder().timeoutMultiplier(0.9);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Timeout multiplier must be >= 1", (Object)ex.getMessage());
        }
    }

    @Test
    public void testBuilderInvalidMaxTimeout() {
        TestGrpcServiceOptions options = ((TestGrpcServiceOptions.Builder)((TestGrpcServiceOptions.Builder)((TestGrpcServiceOptions.Builder)((TestGrpcServiceOptions.Builder)TestGrpcServiceOptions.builder().projectId("project-id")).initialTimeout(1234)).timeoutMultiplier(1.6)).maxTimeout(123)).build();
        Assert.assertEquals((long)1234L, (long)options.initialTimeout());
        Assert.assertEquals((double)1.6, (double)options.timeoutMultiplier(), (double)0.0);
        Assert.assertEquals((long)1234L, (long)options.maxTimeout());
    }

    @Test
    public void testBaseEquals() {
        Assert.assertEquals((Object)((Object)OPTIONS), (Object)((Object)OPTIONS_COPY));
        Assert.assertNotEquals((Object)((Object)DEFAULT_OPTIONS), (Object)((Object)OPTIONS));
        TestGrpcServiceOptions options = ((TestGrpcServiceOptions.Builder)OPTIONS.toBuilder().executorFactory((GrpcServiceOptions.ExecutorFactory)new GrpcServiceOptions.DefaultExecutorFactory())).build();
        Assert.assertNotEquals((Object)((Object)OPTIONS), (Object)((Object)options));
    }

    @Test
    public void testBaseHashCode() {
        Assert.assertEquals((long)OPTIONS.hashCode(), (long)OPTIONS_COPY.hashCode());
        Assert.assertNotEquals((long)DEFAULT_OPTIONS.hashCode(), (long)OPTIONS.hashCode());
        TestGrpcServiceOptions options = ((TestGrpcServiceOptions.Builder)OPTIONS.toBuilder().executorFactory((GrpcServiceOptions.ExecutorFactory)new GrpcServiceOptions.DefaultExecutorFactory())).build();
        Assert.assertNotEquals((long)OPTIONS.hashCode(), (long)options.hashCode());
    }

    @Test
    public void testDefaultExecutorFactory() {
        GrpcServiceOptions.DefaultExecutorFactory executorFactory = new GrpcServiceOptions.DefaultExecutorFactory();
        ScheduledExecutorService executorService = (ScheduledExecutorService)executorFactory.get();
        Assert.assertSame((Object)executorService, (Object)executorFactory.get());
    }

    private static class TestGrpcServiceOptions
    extends GrpcServiceOptions<TestService, TestServiceRpc, TestGrpcServiceOptions> {
        private TestGrpcServiceOptions(Builder builder) {
            super(TestServiceFactory.class, TestServiceRpcFactory.class, (GrpcServiceOptions.Builder)builder);
        }

        protected TestServiceFactory defaultServiceFactory() {
            return DefaultTestServiceFactory.INSTANCE;
        }

        protected TestServiceRpcFactory defaultRpcFactory() {
            return DefaultTestServiceRpcFactory.INSTANCE;
        }

        protected Set<String> scopes() {
            return null;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        private static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object obj) {
            return obj instanceof TestGrpcServiceOptions && this.baseEquals((TestGrpcServiceOptions)((Object)obj));
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        private static class Builder
        extends GrpcServiceOptions.Builder<TestService, TestServiceRpc, TestGrpcServiceOptions, Builder> {
            private Builder() {
            }

            private Builder(TestGrpcServiceOptions options) {
                super((GrpcServiceOptions)options);
            }

            protected TestGrpcServiceOptions build() {
                return new TestGrpcServiceOptions(this);
            }
        }
    }

    private static class DefaultTestServiceRpc
    implements TestServiceRpc {
        DefaultTestServiceRpc(TestGrpcServiceOptions options) {
        }
    }

    private static interface TestServiceRpc {
    }

    private static class DefaultTestServiceRpcFactory
    implements TestServiceRpcFactory {
        private static final TestServiceRpcFactory INSTANCE = new DefaultTestServiceRpcFactory();

        private DefaultTestServiceRpcFactory() {
        }

        public TestServiceRpc create(TestGrpcServiceOptions options) {
            return new DefaultTestServiceRpc(options);
        }
    }

    private static interface TestServiceRpcFactory
    extends ServiceRpcFactory<TestServiceRpc, TestGrpcServiceOptions> {
    }

    private static class DefaultTestServiceFactory
    implements TestServiceFactory {
        private static final TestServiceFactory INSTANCE = new DefaultTestServiceFactory();

        private DefaultTestServiceFactory() {
        }

        public TestService create(TestGrpcServiceOptions options) {
            return new TestServiceImpl(options);
        }
    }

    private static interface TestServiceFactory
    extends ServiceFactory<TestService, TestGrpcServiceOptions> {
    }

    private static class TestServiceImpl
    extends BaseService<TestGrpcServiceOptions>
    implements TestService {
        private TestServiceImpl(TestGrpcServiceOptions options) {
            super((ServiceOptions)options);
        }
    }

    private static interface TestService
    extends Service<TestGrpcServiceOptions> {
    }
}

