/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.BaseService;
import com.google.cloud.HttpServiceOptions;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class HttpServiceOptionsTest {
    private static final HttpServiceOptions.HttpTransportFactory MOCK_HTTP_TRANSPORT_FACTORY = (HttpServiceOptions.HttpTransportFactory)EasyMock.createMock(HttpServiceOptions.HttpTransportFactory.class);
    private static final TestHttpServiceOptions OPTIONS = ((TestHttpServiceOptions.Builder)((TestHttpServiceOptions.Builder)((TestHttpServiceOptions.Builder)((TestHttpServiceOptions.Builder)TestHttpServiceOptions.access$000().projectId("project-id")).connectTimeout(1234)).httpTransportFactory(MOCK_HTTP_TRANSPORT_FACTORY)).readTimeout(5678)).build();
    private static final TestHttpServiceOptions DEFAULT_OPTIONS = ((TestHttpServiceOptions.Builder)TestHttpServiceOptions.access$000().projectId("project-id")).build();
    private static final TestHttpServiceOptions OPTIONS_COPY = OPTIONS.toBuilder().build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((long)1234L, (long)OPTIONS.connectTimeout());
        Assert.assertSame((Object)MOCK_HTTP_TRANSPORT_FACTORY, (Object)OPTIONS.httpTransportFactory());
        Assert.assertEquals((long)5678L, (long)OPTIONS.readTimeout());
        Assert.assertEquals((long)-1L, (long)DEFAULT_OPTIONS.connectTimeout());
        Assert.assertTrue((boolean)(DEFAULT_OPTIONS.httpTransportFactory() instanceof HttpServiceOptions.DefaultHttpTransportFactory));
        Assert.assertEquals((long)-1L, (long)DEFAULT_OPTIONS.readTimeout());
    }

    @Test
    public void testBaseEquals() {
        Assert.assertEquals((Object)((Object)OPTIONS), (Object)((Object)OPTIONS_COPY));
        Assert.assertNotEquals((Object)((Object)DEFAULT_OPTIONS), (Object)((Object)OPTIONS));
    }

    @Test
    public void testBaseHashCode() {
        Assert.assertEquals((long)OPTIONS.hashCode(), (long)OPTIONS_COPY.hashCode());
        Assert.assertNotEquals((long)DEFAULT_OPTIONS.hashCode(), (long)OPTIONS.hashCode());
    }

    private static class TestHttpServiceOptions
    extends HttpServiceOptions<TestService, TestServiceRpc, TestHttpServiceOptions> {
        private TestHttpServiceOptions(Builder builder) {
            super(TestServiceFactory.class, TestServiceRpcFactory.class, (HttpServiceOptions.Builder)builder);
        }

        protected TestServiceFactory defaultServiceFactory() {
            return DefaultTestServiceFactory.INSTANCE;
        }

        protected TestServiceRpcFactory defaultRpcFactory() {
            return DefaultTestServiceRpcFactory.INSTANCE;
        }

        protected Set<String> scopes() {
            return null;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        private static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object obj) {
            return obj instanceof TestHttpServiceOptions && this.baseEquals((TestHttpServiceOptions)((Object)obj));
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        static /* synthetic */ Builder access$000() {
            return TestHttpServiceOptions.builder();
        }

        private static class Builder
        extends HttpServiceOptions.Builder<TestService, TestServiceRpc, TestHttpServiceOptions, Builder> {
            private Builder() {
            }

            private Builder(TestHttpServiceOptions options) {
                super((HttpServiceOptions)options);
            }

            protected TestHttpServiceOptions build() {
                return new TestHttpServiceOptions(this);
            }
        }
    }

    private static class DefaultTestServiceRpc
    implements TestServiceRpc {
        DefaultTestServiceRpc(TestHttpServiceOptions options) {
        }
    }

    private static interface TestServiceRpc {
    }

    private static class DefaultTestServiceRpcFactory
    implements TestServiceRpcFactory {
        private static final TestServiceRpcFactory INSTANCE = new DefaultTestServiceRpcFactory();

        private DefaultTestServiceRpcFactory() {
        }

        public TestServiceRpc create(TestHttpServiceOptions options) {
            return new DefaultTestServiceRpc(options);
        }
    }

    private static interface TestServiceRpcFactory
    extends ServiceRpcFactory<TestServiceRpc, TestHttpServiceOptions> {
    }

    private static class DefaultTestServiceFactory
    implements TestServiceFactory {
        private static final TestServiceFactory INSTANCE = new DefaultTestServiceFactory();

        private DefaultTestServiceFactory() {
        }

        public TestService create(TestHttpServiceOptions options) {
            return new TestServiceImpl(options);
        }
    }

    private static interface TestServiceFactory
    extends ServiceFactory<TestService, TestHttpServiceOptions> {
    }

    private static class TestServiceImpl
    extends BaseService<TestHttpServiceOptions>
    implements TestService {
        private TestServiceImpl(TestHttpServiceOptions options) {
            super((ServiceOptions)options);
        }
    }

    private static interface TestService
    extends Service<TestHttpServiceOptions> {
    }
}

